/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Disable Trade")
@Description(value={"Disables a trade."})
@Examples(value={"disable trade 1 of merchant {_m}"})
@Since(value="0.1.5")
public class EffDisable
extends Effect {
    private Expression<Merchant> merchant;
    private Expression<Integer> integer;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.integer = exprs[0];
        this.merchant = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Merchant trader = (Merchant)this.merchant.getSingle(e);
        Integer index = (Integer)this.integer.getSingle(e);
        if (0 < index && index < trader.getRecipeCount()) {
            MerchantRecipe recipe = MerchantUtils.getRecipe(trader, index);
            MerchantUtils.disableRecipe(recipe);
            trader.setRecipe(index.intValue(), recipe);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "disable trade " + this.integer.toString(e, debug) + " of merchant " + this.merchant.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffDisable.class, (String[])new String[]{"disable (trade|recipe) %integer% of [merchant] %merchant%"});
    }
}

