/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.ProtocolLib;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.effects.ClientSlotPacket;
import com.moderocky.misk.utils.SkriptUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Show Clientside Item")
@Description(value={"Show an entity as wearing an item.", "Slots are MAINHAND, HEAD, CHEST,", "LEGS, FEET and OFFHAND"})
@Examples(value={"show event-entity as wearing stone in slot \"HEAD\" for all players"})
@Since(value="0.1.5")
public class EffShowClientSlot
extends Effect {
    private Expression<Entity> entities;
    private Expression<Player> players;
    private Expression<ItemType> itemtype;
    private Expression<String> string;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.itemtype = exprs[1];
        this.string = exprs[2];
        this.players = exprs[3];
        return true;
    }

    protected void execute(Event event) {
        ItemStack item = SkriptUtils.getItemStack((ItemType)this.itemtype.getSingle(event));
        String slot = (String)this.string.getSingle(event);
        for (Player player : (Player[])this.players.getArray(event)) {
            for (Entity entity : (Entity[])this.entities.getArray(event)) {
                ClientSlotPacket.showClientSlot(entity, player, slot, item);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "show " + this.entities.toString(e, debug) + " as wearing " + this.itemtype.toString(e, debug) + " (on|in) [slot] " + this.string.toString(e, debug) + " for " + this.players.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffShowClientSlot.class, (String[])new String[]{"show %entities% as wearing %itemtype% (on|in) [slot] %string% for %players%"});
    }
}

