/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.utils;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import net.minecraft.server.v1_14_R1.BlockPosition;
import net.minecraft.server.v1_14_R1.MojangsonParser;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.TileEntity;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.craftbukkit.v1_14_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_14_R1.block.CraftContainer;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;

public class LootTableUtils {
    public static LootContext newContext(Location location) {
        return new LootContext.Builder(location).build();
    }

    public static LootContext newContext(Location location, Float luck) {
        return new LootContext.Builder(location).luck(luck.floatValue()).build();
    }

    public static Random newSeed() {
        return new Random();
    }

    public static Random newSeed(Long seed) {
        return new Random(seed);
    }

    public static void populate(BlockInventoryHolder block) {
        Location location = block.getBlock().getLocation();
        LootContext context = LootTableUtils.newContext(location);
        Random seed = LootTableUtils.newSeed();
    }

    public static void populate(Block block) {
        BlockInventoryHolder blockInventoryHolder = (BlockInventoryHolder)block.getState();
        if (blockInventoryHolder != null) {
            LootTableUtils.populate(blockInventoryHolder);
            blockInventoryHolder.getBlock().getState().update();
        }
    }

    public static Boolean hasLootTable(Lootable lootable) {
        if (lootable.getLootTable() != null) {
            return true;
        }
        return false;
    }

    private static String safeString(String string) {
        if (string.contains("\"")) {
            string.replace("\"", "");
        }
        if (string.contains("\\")) {
            string.replace("\\", "");
        }
        if (string.contains(":")) {
            string.replace(":", "");
        }
        return string;
    }

    public static void clearLootTable(Lootable lootable) {
        lootable.setLootTable(null);
    }

    public static void setLootTable(Lootable lootable, LootTable loottable) {
        lootable.setLootTable(loottable);
    }

    public static void setLootTable(Container block, LootTable loottable) {
        Lootable lootable = (Lootable)block.getBlock().getState();
        lootable.setLootTable(loottable);
        block.getBlock().getState().update();
    }

    public static void setLootTable(Block block, LootTable loottable) {
        Lootable lootable = (Lootable)block.getState();
        lootable.setLootTable(loottable);
        block.getState().update();
    }

    public static void setLootTable(Lootable lootable, LootTable loottable, Long seed) {
        lootable.setLootTable(loottable);
        lootable.setSeed(seed.longValue());
    }

    public static Boolean isLocked(Block block) {
        if (block.getState() instanceof Container) {
            Container lockable = (Container)block.getState();
            return lockable.isLocked();
        }
        return false;
    }

    private static void setNMSLock(TileEntity tileentity, String lock) {
        String safeLock = LootTableUtils.safeString(lock);
        try {
            NBTTagCompound key = MojangsonParser.parse((String)("{Lock:\"" + safeLock + "\"}"));
            tileentity.load(key);
            tileentity.update();
        }
        catch (CommandSyntaxException exception) {
            Bukkit.getLogger().warning(exception.getMessage());
        }
    }

    private static void attemptLock(Block block, String lock) {
        if (block.getState() instanceof Container) {
            String safeLock = LootTableUtils.safeString(lock);
            TileEntity tileentity = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()));
            if (tileentity != null) {
                LootTableUtils.setNMSLock(tileentity, safeLock);
            } else {
                Container lockable = (Container)block.getState();
                CraftContainer test = (CraftContainer)lockable;
                CraftBlockEntityState state = (CraftBlockEntityState)block.getState();
                test.setLock(safeLock);
                state.getSnapshotNBT().a(safeLock);
                lockable.setLock(safeLock);
                block.getState().update();
            }
        }
    }

    public static void lock(Block block, String lock) {
        if (block.getState() instanceof Container) {
            LootTableUtils.attemptLock(block, lock);
        }
    }

    public static void unlock(Block block) {
        if (block.getState() instanceof Container) {
            LootTableUtils.attemptLock(block, "");
        }
    }
}

