/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;

@Name(value="Open Villager")
@Description(value={"Opens a villager to players.\n  - This can technically be used to open Wandering Traders as well."})
@Examples(value={"open villager {_m} to player", "open villager event-entity to player"})
@Since(value="0.1.5")
public class EffOpenMerchant
extends Effect {
    private Expression<Entity> entity;
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entity = exprs[0];
        this.players = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Player player = (Player)this.players.getSingle(e);
        if (this.entity.getSingle(e) instanceof Villager) {
            Villager trader = (Villager)this.entity.getSingle(e);
            player.openMerchant(trader, false);
        } else if (this.entity.getSingle(e) instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)this.entity.getSingle(e);
            player.openMerchant((Merchant)trader, false);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "open " + this.entity.toString(e, debug) + " to " + this.players.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffOpenMerchant.class, (String[])new String[]{"open villager %entity% to %player%"});
    }
}

