/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.MerchantUtils;
import com.moderocky.misk.utils.SkriptUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="New Merchant Recipe")
@Description(value={"Create a new trade."})
@Examples(value={"set {_r} to a new trade of stone and stick for oak log"})
@Since(value="0.1.5")
public class ExprMerchantRecipe
extends SimpleExpression<MerchantRecipe> {
    private Expression<ItemType> itemtype1;
    private Expression<ItemType> itemtype2;
    private Expression<ItemType> itemtype3;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemtype1 = exprs[0];
        this.itemtype2 = exprs[1];
        this.itemtype3 = exprs[2];
        return true;
    }

    protected MerchantRecipe[] get(Event e) {
        ArrayList<MerchantRecipe> merchantRecipes = new ArrayList<MerchantRecipe>();
        ItemStack item1 = SkriptUtils.getItemStack((ItemType)this.itemtype1.getSingle(e));
        ItemStack item2 = SkriptUtils.getItemStack((ItemType)this.itemtype2.getSingle(e));
        ItemStack item3 = SkriptUtils.getItemStack((ItemType)this.itemtype3.getSingle(e));
        merchantRecipes.add(MerchantUtils.tradeCreator(item1, item2, item3));
        return merchantRecipes.toArray(new MerchantRecipe[0]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends MerchantRecipe> getReturnType() {
        return MerchantRecipe.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "new trade of " + this.itemtype1.toString(e, debug) + " and " + this.itemtype2.toString(e, debug) + " for " + this.itemtype3.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprMerchantRecipe.class, MerchantRecipe.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] new (merchant recipe|trade) of %itemtypes% and %itemtypes% for %itemtypes%"});
    }
}

