/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.loot;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.LootTableUtils;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Name(value="Lock Container")
@Description(value={"Lock a container, using a text key.", "The name of an item functions as the key to open it."})
@Examples(value={"lock target block with key \"test\""})
@Since(value="0.1.8")
public class EffLock
extends Effect {
    private Expression<Block> blocks;
    private Expression<String> string;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blocks = exprs[0];
        this.string = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Block[] block;
        String key = (String)this.string.getSingle(e);
        for (Block lockable : block = (Block[])this.blocks.getArray(e)) {
            LootTableUtils.lock(lockable, key);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "lock " + this.blocks.toString(e, debug) + " with key " + this.string.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffLock.class, (String[])new String[]{"lock %blocks% with [key] %string%"});
    }
}

