/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Spigot.loot;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.skript.Spigot.loot.CondPlayerLooted;
import com.moderocky.misk.utils.LootTableUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.loot.Lootable;

@Name(value="Has Loot Table")
@Description(value={"Whether a lootable object (container/entity) has a table assigned to it."})
@Examples(value={"{_e} has a loot table"})
@Since(value="0.1.8")
public class CondHasLootTable
extends Condition {
    private Expression<Object> object;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.object = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event e) {
        Lootable lootable = (Lootable)this.object.getSingle(e);
        return LootTableUtils.hasLootTable(lootable);
    }

    public String toString(@Nullable Event e, boolean debug) {
        return PropertyCondition.toString((Condition)this, (PropertyCondition.PropertyType)PropertyCondition.PropertyType.HAVE, (Event)e, (boolean)debug, this.object, (String)"has loot table");
    }

    static {
        Skript.registerCondition(CondPlayerLooted.class, (String[])new String[]{"%object% has [a] loot[ ]table", "%object% does( not|n't) have [a] loot[ ]table"});
    }
}

