/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Bukkit.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.merchant.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.event.Event;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Enable Trade")
@Description(value={"Enable a villager trade."})
@Examples(value={"enable trade 1 of villager {_m}"})
@Since(value="0.1.5")
public class EffEnable
extends Effect {
    private Expression<Entity> entity;
    private Expression<Integer> integer;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.integer = exprs[0];
        this.entity = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Integer index = (Integer)this.integer.getSingle(e);
        if (this.entity.getSingle(e) instanceof Villager) {
            Villager trader = (Villager)this.entity.getSingle(e);
            if (0 < index && index < trader.getRecipeCount()) {
                MerchantRecipe recipe = MerchantUtils.getRecipe(trader, index);
                MerchantUtils.enableRecipe(recipe);
                trader.setRecipe(index.intValue(), recipe);
            }
        } else if (this.entity.getSingle(e) instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)this.entity.getSingle(e);
            if (0 < index && index < trader.getRecipeCount()) {
                MerchantRecipe recipe = MerchantUtils.getRecipe(trader, index);
                MerchantUtils.enableRecipe(recipe);
                trader.setRecipe(index.intValue(), recipe);
            }
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "enable trade " + this.integer.toString(e, debug) + " of villager " + this.entity.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffEnable.class, (String[])new String[]{"enable (trade|recipe) %integer% of villager %entity%"});
    }
}

