/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Bukkit.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.merchant.MerchantUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;

@Name(value="New Merchant")
@Description(value={"Create a new custom merchant object."})
@Examples(value={"set {_m} to a new merchant"})
@Since(value="0.1.5")
public class ExprMerchant
extends SimpleExpression<Merchant> {
    private Expression<String> name;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        return true;
    }

    protected Merchant[] get(Event e) {
        ArrayList<Merchant> merchants = new ArrayList<Merchant>();
        String title = (String)this.name.getSingle(e);
        Merchant trader = MerchantUtils.merchant(title);
        merchants.add(trader);
        return merchants.toArray(new Merchant[0]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Merchant> getReturnType() {
        return Merchant.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "a new merchant named " + this.name.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprMerchant.class, Merchant.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] new merchant named %string%"});
    }
}

