/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Bukkit.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.merchant.MerchantUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;

@Name(value="Merchant From ID")
@Description(value={"Returns an ID-based merchant. Otherwise nothing."})
@Examples(value={"set {_m} to merchant with id \"bob\""})
@Since(value="0.1.5")
public class ExprIDMerchant
extends SimpleExpression<Merchant> {
    private Expression<String> string1;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.string1 = exprs[0];
        return true;
    }

    protected Merchant[] get(Event e) {
        ArrayList<Merchant> merchants = new ArrayList<Merchant>();
        String id = (String)this.string1.getSingle(e);
        if (MerchantUtils.getIDList().containsKey(id)) {
            Merchant trader = MerchantUtils.merchantFromID(id);
            merchants.add(trader);
            return merchants.toArray(new Merchant[0]);
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Merchant> getReturnType() {
        return Merchant.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "merchant with id " + this.string1.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprIDMerchant.class, Merchant.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"merchant [[with ]id] %string%"});
    }
}

