/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Bukkit.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.skript.Bukkit.merchant.EffOpenMerchant;
import com.moderocky.misk.utils.merchant.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;

@Name(value="Save Merchant")
@Description(value={"Saves a merchant to the ID list.", "This will only be saved until restart.", "CMOs can also be saved to a variable.", "Use this if CMO is in a local variable and you need to access it somewhere else."})
@Examples(value={"save merchant {_m} using id \"bob\"", "set {_r} to merchant with id \"bob\""})
@Since(value="0.1.5")
public class EffSaveMerchant
extends Effect {
    private Expression<Merchant> merchant;
    private Expression<String> string;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.merchant = exprs[0];
        this.string = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Merchant trader = (Merchant)this.merchant.getSingle(e);
        String id = (String)this.string.getSingle(e);
        MerchantUtils.saveMerchant(id, trader);
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "save merchant " + this.merchant.toString(e, debug) + " using id " + this.string.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffOpenMerchant.class, (String[])new String[]{"save merchant %merchant% using id %string%"});
    }
}

