/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Bukkit.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;

@Name(value="Open Merchant")
@Description(value={"Opens a merchant to players.\n  - Can be used to open the same merchant to multiple players.\n  - Careful, this might break stuff.\n  - This can technically be used to open Wandering Traders as well."})
@Examples(value={"open merchant {_m} to player", "open merchant {auction-list} to all players"})
@Since(value="0.1.5")
public class EffOpenMerchant
extends Effect {
    private Expression<Merchant> merchant;
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.merchant = exprs[0];
        this.players = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        for (Player player : (Player[])this.players.getArray(e)) {
            Merchant trader = (Merchant)this.merchant.getSingle(e);
            player.openMerchant(trader, true);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "open " + this.merchant.toString(e, debug) + " to " + this.players.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffOpenMerchant.class, (String[])new String[]{"open merchant %merchant% to %players%"});
    }
}

