/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Bukkit.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.merchant.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Enable Trade")
@Description(value={"Enable a trade."})
@Examples(value={"enable trade 1 of merchant {_m}"})
@Since(value="0.1.5")
public class EffEnable
extends Effect {
    private Expression<Merchant> merchant;
    private Expression<Integer> integer;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.integer = exprs[0];
        this.merchant = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Merchant trader = (Merchant)this.merchant.getSingle(e);
        Integer index = (Integer)this.integer.getSingle(e);
        if (0 < index && index < trader.getRecipeCount()) {
            MerchantRecipe recipe = MerchantUtils.getRecipe(trader, index);
            MerchantUtils.enableRecipe(recipe);
            trader.setRecipe(index.intValue(), recipe);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "enable trade " + this.integer.toString(e, debug) + " of merchant " + this.merchant.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffEnable.class, (String[])new String[]{"enable (trade|recipe) %integer% of [merchant] %merchant%"});
    }
}

