/*
 * Decompiled with CFR 0.152.
 */
package com.moderocky.misk.skript.Bukkit.merchant;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.moderocky.misk.utils.merchant.MerchantUtils;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

@Name(value="Add Trade")
@Description(value={"Adds a trade to a merchant."})
@Examples(value={"add trades {_r::*} to {_m}"})
@Since(value="0.1.5")
public class EffAddRecipe
extends Effect {
    private Expression<Merchant> merchant;
    private Expression<MerchantRecipe> merchantrecipes;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.merchantrecipes = exprs[0];
        this.merchant = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        for (MerchantRecipe recipe : (MerchantRecipe[])this.merchantrecipes.getArray(e)) {
            Merchant trader = (Merchant)this.merchant.getSingle(e);
            MerchantUtils.addRecipe(trader, recipe);
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "add " + this.merchantrecipes.toString(e, debug) + " to " + this.merchant.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffAddRecipe.class, (String[])new String[]{"add (trade|recipe)[s] %merchantrecipes% to [merchant] %merchant%"});
    }
}

