/*
 * Decompiled with CFR 0.152.
 */
package com.marquez.marsk.ArmorEquip;

import com.marquez.marsk.ArmorEquip.ArmorType;
import com.marquez.marsk.ArmorEquip.ArmorUnEquipEvent;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ArmorUnEquipListener
implements Listener {
    private final List<String> blockedMaterials;
    private ItemStack itemStack;

    public ArmorUnEquipListener(List<String> blockedMaterials, Plugin main) {
        this.blockedMaterials = blockedMaterials;
        main.getServer().getPluginManager().registerEvents((Listener)this, main);
    }

    @EventHandler
    public final void onInventoryClick(InventoryClickEvent e) {
        boolean shift = false;
        boolean numberkey = false;
        if (e.isCancelled()) {
            return;
        }
        if (!e.getInventory().equals(InventoryType.CREATIVE)) {
            if (e.getClick().equals((Object)ClickType.SHIFT_LEFT) || e.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
                shift = true;
            }
            if (e.getClick().equals((Object)ClickType.NUMBER_KEY)) {
                numberkey = true;
            }
            ArmorUnEquipEvent.EquipMethod method = ArmorUnEquipEvent.EquipMethod.DRAG;
            if (ArmorType.matchType(e.getCurrentItem()) == null) {
                return;
            }
            ArmorType newArmorType = ArmorType.matchType(e.getCurrentItem());
            ArmorUnEquipEvent armorunEquipEvent = new ArmorUnEquipEvent((Player)e.getWhoClicked(), method, newArmorType, e.getCurrentItem());
            if (e.getRawSlot() != newArmorType.getSlot()) {
                return;
            }
            Bukkit.getServer().getPluginManager().callEvent((Event)armorunEquipEvent);
            if (armorunEquipEvent.isCancelled()) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void itemBreakEvent(PlayerItemBreakEvent e) {
        ArmorType type = ArmorType.matchType(e.getBrokenItem());
        if (type != null) {
            Player p = e.getPlayer();
            ArmorUnEquipEvent ArmorUnEquipEvent2 = new ArmorUnEquipEvent(p, ArmorUnEquipEvent.EquipMethod.BROKE, type, e.getBrokenItem());
            Bukkit.getServer().getPluginManager().callEvent((Event)ArmorUnEquipEvent2);
            if (ArmorUnEquipEvent2.isCancelled()) {
                ItemStack i = e.getBrokenItem().clone();
                i.setAmount(1);
                i.setDurability((short)(i.getDurability() - 1));
                if (type.equals((Object)ArmorType.HELMET)) {
                    p.getInventory().setHelmet(i);
                } else if (type.equals((Object)ArmorType.CHESTPLATE)) {
                    p.getInventory().setChestplate(i);
                } else if (type.equals((Object)ArmorType.LEGGINGS)) {
                    p.getInventory().setLeggings(i);
                } else if (type.equals((Object)ArmorType.BOOTS)) {
                    p.getInventory().setBoots(i);
                }
            }
        }
    }

    @EventHandler
    public void playerDeathEvent(PlayerDeathEvent e) {
        Player p = e.getEntity();
        ItemStack[] armorContents = p.getInventory().getArmorContents();
        int length = armorContents.length;
        int j = 0;
        while (j < length) {
            ItemStack i = armorContents[j];
            if (i != null && !i.getType().equals((Object)Material.AIR)) {
                Bukkit.getServer().getPluginManager().callEvent((Event)new ArmorUnEquipEvent(p, ArmorUnEquipEvent.EquipMethod.DEATH, ArmorType.matchType(i), i));
            }
            ++j;
        }
    }
}

