/*
 * Decompiled with CFR 0.152.
 */
package com.marquez.marsk;

import com.marquez.marsk.Main;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class JarUtils {
    private static boolean RUNNING_FROM_JAR = false;

    static {
        URL resource = JarUtils.class.getClassLoader().getResource("plugin.yml");
        if (resource != null) {
            RUNNING_FROM_JAR = true;
        }
    }

    public static JarFile getRunningJar() throws IOException {
        if (!RUNNING_FROM_JAR) {
            return null;
        }
        String path = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getAbsolutePath();
        path = URLDecoder.decode(path, "UTF-8");
        return new JarFile(path);
    }

    public static boolean extractFromJar(String fileName, String dest) throws IOException {
        if (JarUtils.getRunningJar() == null) {
            return false;
        }
        File file = new File(dest);
        if (file.isDirectory()) {
            file.mkdir();
            return false;
        }
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        JarFile jar = JarUtils.getRunningJar();
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (!je.getName().contains(fileName)) continue;
            BufferedInputStream in = new BufferedInputStream(jar.getInputStream(je));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            JarUtils.copyInputStream(in, out);
            jar.close();
            return true;
        }
        jar.close();
        return false;
    }

    public static void reg(String file) {
        try {
            File lib;
            File[] libs;
            File[] fileArray = libs = new File[]{new File(Main.instance.getDataFolder(), file)};
            int n = libs.length;
            int n2 = 0;
            while (n2 < n) {
                lib = fileArray[n2];
                if (!lib.exists()) {
                    JarUtils.extractFromJar(lib.getName(), lib.getAbsolutePath());
                }
                ++n2;
            }
            fileArray = libs;
            n = libs.length;
            n2 = 0;
            while (n2 < n) {
                lib = fileArray[n2];
                if (!lib.exists()) {
                    Main.instance.getLogger().warning("There was a critical error loading My plugin! Could not find lib: " + lib.getName());
                    Bukkit.getServer().getPluginManager().disablePlugin((Plugin)Main.instance);
                    return;
                }
                JarUtils.addClassPath(JarUtils.getJarUrl(lib));
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        try {
            int n;
            byte[] buff = new byte[4096];
            while ((n = in.read(buff)) > 0) {
                out.write(buff, 0, n);
            }
        }
        finally {
            out.flush();
            out.close();
            in.close();
        }
    }

    private static void addClassPath(URL url) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, url);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error adding " + url + " to system classloader");
        }
    }

    public static URL getJarUrl(File file) throws IOException {
        return new URL("jar:" + file.toURI().toURL().toExternalForm() + "!/");
    }
}

