/*
 * Decompiled with CFR 0.152.
 */
package me.pugabyte.litebanssk;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.variables.Variables;
import litebans.api.Entry;
import litebans.api.Events;
import me.pugabyte.litebanssk.skript.events.BanEvent;
import me.pugabyte.litebanssk.skript.events.BroadcastEvent;
import me.pugabyte.litebanssk.skript.events.KickEvent;
import me.pugabyte.litebanssk.skript.events.MuteEvent;
import me.pugabyte.litebanssk.skript.events.WarnEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LiteBansSk
extends JavaPlugin {
    private static LiteBansSk instance;
    private static SkriptAddon addonInstance;
    private Events.Listener entryAdded;
    private Events.Listener broadcastSent;

    public LiteBansSk() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public static LiteBansSk getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    public static SkriptAddon getAddonInstance() {
        if (addonInstance == null) {
            addonInstance = Skript.registerAddon((JavaPlugin)LiteBansSk.getInstance());
        }
        return addonInstance;
    }

    public void onEnable() {
        String version = LiteBansSk.getInstance().getServer().getPluginManager().getPlugin("LiteBans").getDescription().getVersion();
        if (version.startsWith("2.")) {
            try {
                double versionDouble = Double.parseDouble(version.replaceFirst("2.", ""));
                if (versionDouble < 2.5) {
                    this.getLogger().warning("LiteBans is not updated; some features may not work!");
                    this.getLogger().warning("Update: https://www.spigotmc.org/resources/3715/");
                }
            }
            catch (NumberFormatException e) {
                this.getLogger().warning("Could not parse LiteBans version '" + version + "'");
            }
            Player player = Bukkit.getPlayer((String)"Pugabyte");
            Timespan hours = (Timespan)Variables.getVariable((String)("hours::" + player.getUniqueId()), null, (boolean)false);
            long millis = Long.parseLong(hours.toString());
            if (millis >= 3600000L) {
                // empty if block
            }
        }
        try {
            this.register();
        }
        catch (Exception e) {
            this.getLogger().severe("Report this error to https://github.com/Pugabyte/LiteBansSk/issues");
            this.getLogger().severe("Please include LiteBans, LiteBansSk, and Spigot versions");
            e.printStackTrace();
        }
    }

    public void onDisable() {
        Events.get().unregister(this.entryAdded);
        Events.get().unregister(this.broadcastSent);
    }

    public void register() throws Exception {
        this.entryAdded = new Events.Listener(){

            public void entryAdded(Entry entry) {
                if (entry.getType().equals("ban")) {
                    instance.getServer().getScheduler().runTaskLater((Plugin)instance, () -> instance.getServer().getPluginManager().callEvent((Event)new BanEvent(entry)), 0L);
                } else if (entry.getType().equals("mute")) {
                    instance.getServer().getScheduler().runTaskLater((Plugin)instance, () -> instance.getServer().getPluginManager().callEvent((Event)new MuteEvent(entry)), 0L);
                } else if (entry.getType().equals("kick")) {
                    instance.getServer().getScheduler().runTaskLater((Plugin)instance, () -> instance.getServer().getPluginManager().callEvent((Event)new KickEvent(entry)), 0L);
                } else if (entry.getType().equals("warn")) {
                    instance.getServer().getScheduler().runTaskLater((Plugin)instance, () -> instance.getServer().getPluginManager().callEvent((Event)new WarnEvent(entry)), 0L);
                }
            }
        };
        this.broadcastSent = new Events.Listener(){

            public void broadcastSent(String message, String type) {
                LiteBansSk.getInstance().getServer().getPluginManager().callEvent((Event)new BroadcastEvent(message, type));
            }
        };
        Events.get().register(this.entryAdded);
        Events.get().register(this.broadcastSent);
        Classes.registerClass((ClassInfo)new ClassInfo(Entry.class, "entry").defaultExpression((DefaultExpression)new EventValueExpression(Entry.class)).user(new String[]{"entry"}).name("entry").parser((Parser)new Parser<Entry>(){

            public boolean canParse(ParseContext context) {
                return false;
            }

            public Entry parse(String string, ParseContext parseContext) {
                return null;
            }

            public String toString(Entry entry, int flags) {
                return Integer.toString(entry.getId());
            }

            public String toVariableNameString(Entry entry) {
                return Integer.toString(entry.getId());
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(BroadcastEvent.class, "broadcast").defaultExpression((DefaultExpression)new EventValueExpression(BroadcastEvent.class)).user(new String[]{"broadcast"}).name("broadcast").parser((Parser)new Parser<BroadcastEvent>(){

            public boolean canParse(ParseContext context) {
                return false;
            }

            public BroadcastEvent parse(String string, ParseContext parseContext) {
                return null;
            }

            public String toString(BroadcastEvent event, int flags) {
                return event.getMessage();
            }

            public String toVariableNameString(BroadcastEvent event) {
                return event.getMessage();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        LiteBansSk.getAddonInstance().loadClasses("me.pugabyte.litebanssk.skript", new String[0]);
    }
}

