/*
 * Decompiled with CFR 0.152.
 */
package org.codemc.worldguardwrapper.implementation.v7.region;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.codemc.worldguardwrapper.flag.IWrappedFlag;
import org.codemc.worldguardwrapper.implementation.v7.flag.AbstractWrappedFlag;
import org.codemc.worldguardwrapper.implementation.v7.utility.WorldGuardFlagUtilities;
import org.codemc.worldguardwrapper.region.IWrappedDomain;
import org.codemc.worldguardwrapper.region.IWrappedRegion;
import org.codemc.worldguardwrapper.selection.ICuboidSelection;
import org.codemc.worldguardwrapper.selection.IPolygonalSelection;
import org.codemc.worldguardwrapper.selection.ISelection;

public class WrappedRegion
implements IWrappedRegion {
    private final World world;
    private final ProtectedRegion handle;

    @Override
    public ISelection getSelection() {
        if (this.handle instanceof ProtectedPolygonalRegion) {
            return new IPolygonalSelection(){

                @Override
                public Set<Location> getPoints() {
                    return WrappedRegion.this.handle.getPoints().stream().map(BlockVector2::toBlockVector3).map(vector -> BukkitAdapter.adapt((World)WrappedRegion.this.world, (BlockVector3)vector)).collect(Collectors.toSet());
                }

                @Override
                public int getMinimumY() {
                    return WrappedRegion.this.handle.getMinimumPoint().getBlockY();
                }

                @Override
                public int getMaximumY() {
                    return WrappedRegion.this.handle.getMaximumPoint().getBlockY();
                }
            };
        }
        return new ICuboidSelection(){

            @Override
            public Location getMinimumPoint() {
                return BukkitAdapter.adapt((World)WrappedRegion.this.world, (BlockVector3)WrappedRegion.this.handle.getMinimumPoint());
            }

            @Override
            public Location getMaximumPoint() {
                return BukkitAdapter.adapt((World)WrappedRegion.this.world, (BlockVector3)WrappedRegion.this.handle.getMaximumPoint());
            }
        };
    }

    @Override
    public String getId() {
        return this.handle.getId();
    }

    @Override
    public Map<IWrappedFlag<?>, Object> getFlags() {
        HashMap result = new HashMap();
        this.handle.getFlags().forEach((flag, value) -> {
            if (value != null) {
                try {
                    IWrappedFlag<?> wrappedFlag = WorldGuardFlagUtilities.wrapFixType(flag, value.getClass());
                    Optional<Object> wrappedValue = ((AbstractWrappedFlag)wrappedFlag).fromWGValue(value);
                    wrappedValue.ifPresent(val -> result.put(wrappedFlag, val));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        return result;
    }

    @Override
    public <T> Optional<T> getFlag(IWrappedFlag<T> flag) {
        AbstractWrappedFlag wrappedFlag = (AbstractWrappedFlag)flag;
        return Optional.ofNullable(this.handle.getFlag(wrappedFlag.getHandle())).map(value -> wrappedFlag.fromWGValue(value));
    }

    @Override
    public <T> void setFlag(IWrappedFlag<T> flag, T value) {
        AbstractWrappedFlag wrappedFlag = (AbstractWrappedFlag)flag;
        this.handle.setFlag(wrappedFlag.getHandle(), wrappedFlag.fromWrapperValue(value).orElse(null));
    }

    @Override
    public int getPriority() {
        return this.handle.getPriority();
    }

    @Override
    public IWrappedDomain getOwners() {
        return new IWrappedDomain(){

            @Override
            public Set<UUID> getPlayers() {
                return WrappedRegion.this.handle.getOwners().getUniqueIds();
            }

            @Override
            public void addPlayer(UUID uuid) {
                WrappedRegion.this.handle.getOwners().addPlayer(uuid);
            }

            @Override
            public void removePlayer(UUID uuid) {
                WrappedRegion.this.handle.getOwners().removePlayer(uuid);
            }

            @Override
            public Set<String> getGroups() {
                return WrappedRegion.this.handle.getOwners().getGroups();
            }

            @Override
            public void addGroup(String name) {
                WrappedRegion.this.handle.getOwners().addGroup(name);
            }

            @Override
            public void removeGroup(String name) {
                WrappedRegion.this.handle.getOwners().removeGroup(name);
            }
        };
    }

    @Override
    public IWrappedDomain getMembers() {
        return new IWrappedDomain(){

            @Override
            public Set<UUID> getPlayers() {
                return WrappedRegion.this.handle.getMembers().getUniqueIds();
            }

            @Override
            public void addPlayer(UUID uuid) {
                WrappedRegion.this.handle.getMembers().addPlayer(uuid);
            }

            @Override
            public void removePlayer(UUID uuid) {
                WrappedRegion.this.handle.getMembers().removePlayer(uuid);
            }

            @Override
            public Set<String> getGroups() {
                return WrappedRegion.this.handle.getMembers().getGroups();
            }

            @Override
            public void addGroup(String name) {
                WrappedRegion.this.handle.getMembers().addGroup(name);
            }

            @Override
            public void removeGroup(String name) {
                WrappedRegion.this.handle.getMembers().removeGroup(name);
            }
        };
    }

    @Override
    public boolean contains(Location location) {
        return this.handle.contains(BukkitAdapter.asBlockVector((Location)location));
    }

    public WrappedRegion(World world, ProtectedRegion handle) {
        this.world = world;
        this.handle = handle;
    }

    public World getWorld() {
        return this.world;
    }

    public ProtectedRegion getHandle() {
        return this.handle;
    }
}

