/*
 * Decompiled with CFR 0.152.
 */
package org.codemc.worldguardwrapper.implementation.v7;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.BooleanFlag;
import com.sk89q.worldguard.protection.flags.DoubleFlag;
import com.sk89q.worldguard.protection.flags.EnumFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.IntegerFlag;
import com.sk89q.worldguard.protection.flags.LocationFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.protection.flags.VectorFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import org.codemc.worldguardwrapper.flag.IWrappedFlag;
import org.codemc.worldguardwrapper.flag.WrappedState;
import org.codemc.worldguardwrapper.implementation.IWorldGuardImplementation;
import org.codemc.worldguardwrapper.implementation.v7.flag.AbstractWrappedFlag;
import org.codemc.worldguardwrapper.implementation.v7.region.WrappedRegion;
import org.codemc.worldguardwrapper.implementation.v7.utility.WorldGuardFlagUtilities;
import org.codemc.worldguardwrapper.region.IWrappedRegion;

public class WorldGuardImplementation
implements IWorldGuardImplementation {
    private final WorldGuard core = WorldGuard.getInstance();
    private final FlagRegistry flagRegistry = this.core.getFlagRegistry();
    private final WorldGuardPlugin plugin = WorldGuardPlugin.inst();

    private Optional<LocalPlayer> wrapPlayer(Player player) {
        return Optional.ofNullable(player).map(bukkitPlayer -> this.plugin.wrapPlayer(player));
    }

    private Optional<RegionManager> getWorldManager(@NonNull org.bukkit.World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return Optional.ofNullable(this.core.getPlatform().getRegionContainer().get(BukkitAdapter.adapt((org.bukkit.World)world)));
    }

    private Optional<ApplicableRegionSet> getApplicableRegions(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return this.getWorldManager(location.getWorld()).map(manager -> manager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location)));
    }

    private Optional<ApplicableRegionSet> getApplicableRegions(@NonNull Location minimum, @NonNull Location maximum) {
        if (minimum == null) {
            throw new NullPointerException("minimum is marked non-null but is null");
        }
        if (maximum == null) {
            throw new NullPointerException("maximum is marked non-null but is null");
        }
        return this.getWorldManager(minimum.getWorld()).map(manager -> manager.getApplicableRegions((ProtectedRegion)new ProtectedCuboidRegion("temp", BukkitAdapter.asBlockVector((Location)minimum), BukkitAdapter.asBlockVector((Location)maximum))));
    }

    private <V> Optional<V> queryValue(Player player, @NonNull Location location, @NonNull Flag<V> flag) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return this.getApplicableRegions(location).map(applicableRegions -> applicableRegions.queryValue((RegionAssociable)this.wrapPlayer(player).orElse(null), flag));
    }

    @Override
    public JavaPlugin getWorldGuardPlugin() {
        return WorldGuardPlugin.inst();
    }

    @Override
    public int getApiVersion() {
        return 7;
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> getFlag(String name, Class<T> type) {
        return Optional.ofNullable(this.flagRegistry.get(name)).map(flag -> WorldGuardFlagUtilities.wrap(flag, type));
    }

    @Override
    public <T> Optional<T> queryFlag(Player player, Location location, IWrappedFlag<T> flag) {
        AbstractWrappedFlag wrappedFlag = (AbstractWrappedFlag)flag;
        return this.queryValue(player, location, wrappedFlag.getHandle()).flatMap(value -> wrappedFlag.fromWGValue(value));
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> registerFlag(String name, Class<T> type, T defaultValue) {
        StateFlag flag;
        if (type.equals(WrappedState.class)) {
            flag = new StateFlag(name, defaultValue == WrappedState.ALLOW);
        } else if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            flag = new BooleanFlag(name);
        } else if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            flag = new DoubleFlag(name);
        } else if (type.equals(Enum.class)) {
            flag = new EnumFlag(name, type);
        } else if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            flag = new IntegerFlag(name);
        } else if (type.equals(Location.class)) {
            flag = new LocationFlag(name);
        } else if (type.equals(String.class)) {
            flag = new StringFlag(name, (String)defaultValue);
        } else if (type.equals(Vector.class)) {
            flag = new VectorFlag(name);
        } else {
            throw new IllegalArgumentException("Unsupported flag type " + type.getName());
        }
        try {
            this.flagRegistry.register((Flag)flag);
            return Optional.of(WorldGuardFlagUtilities.wrap(flag, type));
        }
        catch (FlagConflictException flagConflictException) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<IWrappedRegion> getRegion(org.bukkit.World world, String id) {
        return this.getWorldManager(world).map(regionManager -> regionManager.getRegion(id)).map(region -> new WrappedRegion(world, (ProtectedRegion)region));
    }

    @Override
    public Map<String, IWrappedRegion> getRegions(org.bukkit.World world) {
        RegionManager regionManager = this.core.getPlatform().getRegionContainer().get((World)new BukkitWorld(world));
        if (regionManager == null) {
            return Collections.emptyMap();
        }
        Map regions = regionManager.getRegions();
        HashMap<String, IWrappedRegion> map = new HashMap<String, IWrappedRegion>();
        regions.forEach((name, region) -> {
            IWrappedRegion cfr_ignored_0 = map.put((String)name, new WrappedRegion(world, (ProtectedRegion)region));
        });
        return map;
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location location) {
        ApplicableRegionSet regionSet = this.getApplicableRegions(location).orElse(null);
        if (regionSet == null) {
            return Collections.emptySet();
        }
        return regionSet.getRegions().stream().map(region -> new WrappedRegion(location.getWorld(), (ProtectedRegion)region)).collect(Collectors.toSet());
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location minimum, Location maximum) {
        ApplicableRegionSet regionSet = this.getApplicableRegions(minimum, maximum).orElse(null);
        if (regionSet == null) {
            return Collections.emptySet();
        }
        return regionSet.getRegions().stream().map(region -> new WrappedRegion(minimum.getWorld(), (ProtectedRegion)region)).collect(Collectors.toSet());
    }

    @Override
    public Optional<IWrappedRegion> addRegion(String id, List<Location> points, int minY, int maxY) {
        ProtectedCuboidRegion region;
        org.bukkit.World world = points.get(0).getWorld();
        if (points.size() == 2) {
            region = new ProtectedCuboidRegion(id, BukkitAdapter.asBlockVector((Location)points.get(0)), BukkitAdapter.asBlockVector((Location)points.get(1)));
        } else {
            List vectorPoints = points.stream().map(location -> BukkitAdapter.asBlockVector((Location)location).toBlockVector2()).collect(Collectors.toList());
            region = new ProtectedPolygonalRegion(id, vectorPoints, minY, maxY);
        }
        Optional<RegionManager> manager = this.getWorldManager(world);
        if (manager.isPresent()) {
            manager.get().addRegion((ProtectedRegion)region);
            return Optional.of(new WrappedRegion(world, (ProtectedRegion)region));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Set<IWrappedRegion>> removeRegion(org.bukkit.World world, String id) {
        Optional<Set> set = this.getWorldManager(world).map(manager -> manager.removeRegion(id));
        return set.map(protectedRegions -> protectedRegions.stream().map(region -> new WrappedRegion(world, (ProtectedRegion)region)).collect(Collectors.toSet()));
    }
}

