/*
 * Decompiled with CFR 0.152.
 */
package org.codemc.worldguardwrapper.implementation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.codemc.worldguardwrapper.flag.IWrappedFlag;
import org.codemc.worldguardwrapper.region.IWrappedRegion;
import org.codemc.worldguardwrapper.selection.ICuboidSelection;
import org.codemc.worldguardwrapper.selection.IPolygonalSelection;
import org.codemc.worldguardwrapper.selection.ISelection;

public interface IWorldGuardImplementation {
    public JavaPlugin getWorldGuardPlugin();

    public int getApiVersion();

    public <T> Optional<T> queryFlag(Player var1, @NonNull Location var2, @NonNull IWrappedFlag<T> var3);

    public <T> Optional<IWrappedFlag<T>> getFlag(String var1, Class<T> var2);

    public <T> Optional<IWrappedFlag<T>> registerFlag(@NonNull String var1, @NonNull Class<T> var2, T var3);

    default public <T> Optional<IWrappedFlag<T>> registerFlag(@NonNull String name, @NonNull Class<T> type) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.registerFlag(name, type, null);
    }

    public Optional<IWrappedRegion> getRegion(@NonNull World var1, @NonNull String var2);

    public Map<String, IWrappedRegion> getRegions(@NonNull World var1);

    public Set<IWrappedRegion> getRegions(@NonNull Location var1);

    public Set<IWrappedRegion> getRegions(@NonNull Location var1, @NonNull Location var2);

    public Optional<IWrappedRegion> addRegion(@NonNull String var1, @NonNull List<Location> var2, int var3, int var4);

    default public Optional<IWrappedRegion> addCuboidRegion(@NonNull String id, @NonNull Location point1, @NonNull Location point2) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (point1 == null) {
            throw new NullPointerException("point1 is marked non-null but is null");
        }
        if (point2 == null) {
            throw new NullPointerException("point2 is marked non-null but is null");
        }
        return this.addRegion(id, Arrays.asList(point1, point2), 0, 0);
    }

    default public Optional<IWrappedRegion> addRegion(@NonNull String id, @NonNull ISelection selection) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (selection == null) {
            throw new NullPointerException("selection is marked non-null but is null");
        }
        if (selection instanceof ICuboidSelection) {
            ICuboidSelection sel = (ICuboidSelection)selection;
            return this.addCuboidRegion(id, sel.getMinimumPoint(), sel.getMaximumPoint());
        }
        if (selection instanceof IPolygonalSelection) {
            IPolygonalSelection sel = (IPolygonalSelection)selection;
            return this.addRegion(id, new ArrayList<Location>(sel.getPoints()), sel.getMinimumY(), sel.getMaximumY());
        }
        return Optional.empty();
    }

    public Optional<Set<IWrappedRegion>> removeRegion(@NonNull World var1, @NonNull String var2);
}

