/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.leaf.Leaf;
import com.leaf.yaml.utils.StringUtil;
import com.leaf.yaml.utils.yaml.YAMLProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Return All YAML loaded in memory")
@Description(value={"Returns a list of all \"cached\" yaml file IDs."})
@Examples(value={"set {_list::*} to the currently loaded yaml files", "broadcast \"%{_list::*}%\"", " ", "loop the loaded yaml", "\tbroadcast loop-value", " ", "loop the loaded yaml from directory \"plugins\\skript-yaml\"", "\tbroadcast loop-value", " ", "loop the loaded yaml directories", "\tbroadcast loop-value"})
@Since(value="1.0.0")
public class ExprAllLoadedYaml
extends SimpleExpression<String> {
    private Expression<String> directory;
    private int matchedPattern;

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        if (matchedPattern == 0) {
            this.directory = exprs[0];
        }
        this.matchedPattern = matchedPattern;
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        if (this.matchedPattern == 0) {
            return "(the|all [of the]) [currently] loaded y[a]ml [files]" + (this.directory != null ? " from directory " + this.directory.toString(event, debug) : "");
        }
        return "(the|all [of the]) [currently] loaded y[a]ml directories";
    }

    @Nullable
    protected String[] get(Event event) {
        if (this.matchedPattern == 0) {
            if (this.directory == null) {
                if (Leaf.YAML_STORE.isEmpty()) {
                    return null;
                }
                return Leaf.YAML_STORE.keySet().toArray(new String[Leaf.YAML_STORE.keySet().size()]);
            }
            return this.getYamlFromDirectories((String[])this.directory.getAll(event));
        }
        return this.getAllDirectories();
    }

    private String[] getYamlFromDirectories(String ... directories) {
        ArrayList<String> yamlNames = new ArrayList<String>();
        String server = new File("").getAbsoluteFile().getAbsolutePath() + File.separator;
        ArrayList<String> filter = new ArrayList<String>();
        for (String d : directories) {
            if (d.startsWith(server)) {
                filter.add(StringUtil.stripLastSeparator(StringUtil.checkSeparator(d)));
                continue;
            }
            filter.add(server + StringUtil.stripLastSeparator(StringUtil.checkSeparator(d)));
        }
        for (Map.Entry<String, YAMLProcessor> entry : Leaf.YAML_STORE.entrySet()) {
            String id;
            if (!filter.contains(entry.getValue().getParentPath()) || yamlNames.contains(id = entry.getKey())) continue;
            yamlNames.add(id);
        }
        if (yamlNames.isEmpty()) {
            return null;
        }
        return yamlNames.toArray(new String[yamlNames.size()]);
    }

    private String[] getAllDirectories() {
        ArrayList<String> yamlDirectories = new ArrayList<String>();
        Iterator<Map.Entry<String, YAMLProcessor>> it = Leaf.YAML_STORE.entrySet().iterator();
        while (it.hasNext()) {
            String path = it.next().getValue().getParentPath();
            if (yamlDirectories.contains(path)) continue;
            yamlDirectories.add(path);
        }
        return yamlDirectories.toArray(new String[yamlDirectories.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    static {
        Skript.registerExpression(ExprAllLoadedYaml.class, String.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[(the|all [(of the|the)])] [currently] loaded y[a]ml [files] [from (director(y|ies) %-strings%|all directories)]", "[(the|all [(of the|the)])] [currently] loaded y[a]ml directories"});
    }
}

