/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.skriptmirror.util;

import ch.njol.skript.Skript;
import com.leaf.skriptmirror.JavaType;
import com.leaf.skriptmirror.Null;
import com.leaf.skriptmirror.ObjectWrapper;
import com.leaf.skriptmirror.util.SkriptUtil;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SkriptMirrorUtil {
    public static final String IDENTIFIER = "[_a-zA-Z$][\\w$]*";
    public static final String PACKAGE = "(?:[_a-zA-Z$][\\w$]*\\.)*(?:[_a-zA-Z$][\\w$]*)";
    private static final Pattern TYPE_PREFIXES = Pattern.compile("^[-*~]*");

    public static Class<?> toClassUnwrapJavaTypes(Object o) {
        if (o instanceof JavaType) {
            return ((JavaType)o).getJavaClass();
        }
        return SkriptMirrorUtil.getClass(o);
    }

    public static String getDebugName(Class<?> cls) {
        return Skript.logVeryHigh() ? cls.getName() : cls.getSimpleName();
    }

    public static Class<?> getClass(Object o) {
        if ((o = ObjectWrapper.unwrapIfNecessary(o)) == null) {
            return Object.class;
        }
        return o.getClass();
    }

    public static String preprocessPattern(String pattern) {
        StringBuilder newPattern = new StringBuilder(pattern.length());
        String[] parts = pattern.split("%");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i % 2 == 0) {
                newPattern.append(part);
                continue;
            }
            part = part.startsWith("_") ? (part.endsWith("s") ? "javaobjects" : "javaobject") : SkriptMirrorUtil.processTypes(part);
            newPattern.append('%');
            newPattern.append(part);
            newPattern.append('%');
        }
        return newPattern.toString();
    }

    public static String processTypes(String part) {
        if (part.length() > 0) {
            String prefixes = "";
            Matcher prefixMatcher = TYPE_PREFIXES.matcher(part);
            if (prefixMatcher.find()) {
                prefixes = prefixMatcher.group();
            }
            part = part.substring(prefixes.length());
            String suffixes = "";
            int timeIndex = part.indexOf("@");
            if (timeIndex != -1) {
                suffixes = part.substring(timeIndex);
                part = part.substring(0, timeIndex);
            }
            String types = Arrays.stream(part.split("/")).map(SkriptUtil::replaceUserInputPatterns).collect(Collectors.joining("/"));
            return prefixes + types + suffixes;
        }
        return part;
    }

    public static Object reifyIfNull(Object o) {
        return o == null ? Null.getInstance() : o;
    }
}

