/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.skriptmirror.skript.custom.condition;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.util.Utils;
import com.leaf.skriptmirror.skript.custom.CustomSyntaxSection;
import com.leaf.skriptmirror.skript.custom.SyntaxParseEvent;
import com.leaf.skriptmirror.skript.custom.condition.ConditionCheckEvent;
import com.leaf.skriptmirror.skript.custom.condition.ConditionSyntaxInfo;
import com.leaf.skriptmirror.skript.custom.condition.CustomCondition;
import com.leaf.skriptmirror.util.SkriptUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.stream.Collectors;

public class CustomConditionSection
extends CustomSyntaxSection<ConditionSyntaxInfo> {
    private static CustomSyntaxSection.DataTracker<ConditionSyntaxInfo> dataTracker;
    static Map<ConditionSyntaxInfo, Trigger> conditionHandlers;
    static Map<ConditionSyntaxInfo, Trigger> parserHandlers;

    @Override
    public CustomSyntaxSection.DataTracker<ConditionSyntaxInfo> getDataTracker() {
        return dataTracker;
    }

    @Override
    protected boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult, SectionNode node) {
        SectionNode patterns = (SectionNode)node.get("patterns");
        File script = (parseResult.mark & 1) == 1 ? SkriptUtil.getCurrentScript() : null;
        switch (matchedPattern) {
            case 0: {
                String what = ((MatchResult)parseResult.regexes.get(0)).group();
                this.register(ConditionSyntaxInfo.create(script, what, 1, false, false));
                break;
            }
            case 1: {
                if (patterns == null) {
                    Skript.error((String)"Custom conditions without inline patterns must have a patterns section.");
                    return false;
                }
                int i = 1;
                for (Node subNode : patterns) {
                    this.register(ConditionSyntaxInfo.create(script, subNode.getKey(), i++, false, false));
                }
                break;
            }
            case 2: {
                String what = ((MatchResult)parseResult.regexes.get(0)).group();
                String type = Arrays.stream((ClassInfo[])args[0].getArray()).map(ClassInfo::getCodeName).map(codeName -> {
                    boolean isPlural = (Boolean)Utils.getEnglishPlural((String)codeName).getSecond();
                    if (!isPlural) {
                        return Utils.toEnglishPlural((String)codeName);
                    }
                    return codeName;
                }).collect(Collectors.joining("/"));
                this.register(ConditionSyntaxInfo.create(script, "%" + type + "% (is|are) " + what, 1, false, true));
                this.register(ConditionSyntaxInfo.create(script, "%" + type + "% (isn't|is not|aren't|are not) " + what, 1, true, true));
            }
        }
        if (matchedPattern != 1 && patterns != null) {
            Skript.error((String)"Custom conditions with inline patterns may not have a patterns section.");
            return false;
        }
        return CustomConditionSection.handleEntriesAndSections(node, entryNode -> false, sectionNode -> {
            String key = sectionNode.getKey();
            if (key.equalsIgnoreCase("patterns")) {
                return true;
            }
            if (key.equalsIgnoreCase("check")) {
                ScriptLoader.setCurrentEvent((String)"custom condition check", (Class[])new Class[]{ConditionCheckEvent.class});
                List<TriggerItem> items = SkriptUtil.getItemsFromNode(sectionNode);
                this.whichInfo.forEach(which -> conditionHandlers.put((ConditionSyntaxInfo)which, new Trigger(SkriptUtil.getCurrentScript(), "condition " + which, (SkriptEvent)this, items)));
                return true;
            }
            if (key.equalsIgnoreCase("parse")) {
                SyntaxParseEvent.register(this, sectionNode, this.whichInfo, parserHandlers);
                return true;
            }
            return false;
        });
    }

    public static ConditionSyntaxInfo lookup(File script, int matchedPattern) {
        return dataTracker.lookup(script, matchedPattern);
    }

    static {
        CustomSyntaxSection.register("Define Condition", CustomConditionSection.class, "[(1\u00a6local)] condition <.+>", "[(1\u00a6local)] condition", "[(1\u00a6local)] %*classinfos% property condition <.+>");
        dataTracker = new CustomSyntaxSection.DataTracker();
        conditionHandlers = new HashMap<ConditionSyntaxInfo, Trigger>();
        parserHandlers = new HashMap<ConditionSyntaxInfo, Trigger>();
        dataTracker.setSyntaxType("condition");
        Skript.registerCondition(CustomCondition.class, (String[])new String[0]);
        Optional<SyntaxElementInfo> info = Skript.getConditions().stream().filter(i -> i.c == CustomCondition.class).findFirst();
        info.ifPresent(dataTracker::setInfo);
        dataTracker.addManaged(conditionHandlers);
        dataTracker.addManaged(parserHandlers);
    }
}

