/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.skriptmirror.skript.custom.condition;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import com.leaf.skriptmirror.skript.custom.SyntaxParseEvent;
import com.leaf.skriptmirror.skript.custom.condition.ConditionCheckEvent;
import com.leaf.skriptmirror.skript.custom.condition.ConditionSyntaxInfo;
import com.leaf.skriptmirror.skript.custom.condition.CustomConditionSection;
import com.leaf.skriptmirror.util.SkriptReflection;
import com.leaf.skriptmirror.util.SkriptUtil;
import java.util.Arrays;
import org.bukkit.event.Event;

public class CustomCondition
extends Condition {
    private ConditionSyntaxInfo which;
    private Expression<?>[] exprs;
    private SkriptParser.ParseResult parseResult;
    private Event parseEvent;

    public boolean check(Event e) {
        Trigger checker = CustomConditionSection.conditionHandlers.get(this.which);
        if (checker == null) {
            Skript.error((String)String.format("The custom condtion '%s' no longer has a check handler.", this.which.getPattern()));
            return false;
        }
        if (this.which.isProperty()) {
            return this.checkByProperty(e, checker);
        }
        return this.checkByStandard(e, checker);
    }

    private boolean checkByStandard(Event e, Trigger checker) {
        ConditionCheckEvent conditionEvent = new ConditionCheckEvent(e, this.exprs, this.which.getMatchedPattern(), this.parseResult);
        SkriptReflection.copyVariablesMap(this.parseEvent, conditionEvent);
        checker.execute((Event)conditionEvent);
        return conditionEvent.isMarkedContinue() ^ conditionEvent.isMarkedNegated() ^ this.which.isInverted();
    }

    private boolean checkByProperty(Event e, Trigger checker) {
        return this.exprs[0].check(e, o -> {
            Expression<?>[] localExprs = Arrays.copyOf(this.exprs, this.exprs.length);
            localExprs[0] = new SimpleLiteral(o, false);
            ConditionCheckEvent conditionEvent = new ConditionCheckEvent(e, localExprs, this.which.getMatchedPattern(), this.parseResult);
            SkriptReflection.copyVariablesMap(this.parseEvent, conditionEvent);
            checker.execute((Event)conditionEvent);
            return conditionEvent.isMarkedContinue() ^ conditionEvent.isMarkedNegated();
        }, this.which.isInverted());
    }

    public String toString(Event e, boolean debug) {
        return this.which.getPattern();
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.which = CustomConditionSection.lookup(SkriptUtil.getCurrentScript(), matchedPattern);
        if (this.which == null) {
            return false;
        }
        this.exprs = (Expression[])Arrays.stream(exprs).map(SkriptUtil::defendExpression).toArray(Expression[]::new);
        this.parseResult = parseResult;
        if (!SkriptUtil.canInitSafely(this.exprs)) {
            return false;
        }
        Trigger parseHandler = CustomConditionSection.parserHandlers.get(this.which);
        if (parseHandler != null) {
            SyntaxParseEvent event = new SyntaxParseEvent(this.exprs, matchedPattern, parseResult, ScriptLoader.getCurrentEvents());
            parseHandler.execute((Event)event);
            if (SkriptReflection.hasLocalVariables(event)) {
                this.parseEvent = event;
            }
            return event.isMarkedContinue();
        }
        return true;
    }
}

