/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.skriptmirror.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.leaf.skriptmirror.ScriptLoaderState;
import com.leaf.skriptmirror.skript.Consent;
import com.leaf.skriptmirror.util.SkriptUtil;
import java.util.regex.MatchResult;
import org.bukkit.event.Event;

public class CondParseLater
extends Condition {
    private String statement;
    private ScriptLoaderState scriptLoaderState;
    private Statement parsedStatement;

    public boolean check(Event e) {
        Condition parsedCondition = this.getParsedCondition();
        if (parsedCondition == null) {
            return false;
        }
        return parsedCondition.check(e);
    }

    protected TriggerItem walk(Event e) {
        Statement parsedStatement = this.getParsedStatement();
        if (parsedStatement == null) {
            return null;
        }
        TriggerItem.walk((TriggerItem)parsedStatement, (Event)e);
        return null;
    }

    public String toString(Event e, boolean debug) {
        if (this.parsedStatement != null) {
            return "parsed later: " + this.parsedStatement.toString(e, debug);
        }
        return "not parsed yet: " + this.statement;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Consent.Feature.DEFERRED_PARSING.hasConsent(SkriptUtil.getCurrentScript())) {
            return false;
        }
        this.statement = ((MatchResult)parseResult.regexes.get(0)).group();
        this.scriptLoaderState = ScriptLoaderState.copyOfCurrentState();
        return true;
    }

    private Statement getParsedStatement() {
        if (this.parsedStatement == null) {
            this.scriptLoaderState.applyToCurrentState();
            this.parsedStatement = Statement.parse((String)this.statement, (String)String.format("Could not parse condition/effect at runtime: %s", this.statement));
            if (this.parsedStatement == null) {
                return null;
            }
            this.parsedStatement.setNext(this.getNext());
            this.parsedStatement.setParent(this.getParent());
        }
        return this.parsedStatement;
    }

    private Condition getParsedCondition() {
        if (this.parsedStatement == null) {
            this.scriptLoaderState.applyToCurrentState();
            this.parsedStatement = Condition.parse((String)this.statement, (String)String.format("Could not parse condition at runtime: %s", this.statement));
            if (this.parsedStatement == null) {
                return null;
            }
            this.parsedStatement.setNext(this.getNext());
            this.parsedStatement.setParent(this.getParent());
        }
        if (!(this.parsedStatement instanceof Condition)) {
            throw new IllegalStateException(String.format("%s was used as a condition but was parsed as a statement", this.statement));
        }
        return (Condition)this.parsedStatement;
    }

    static {
        Skript.registerCondition(CondParseLater.class, (String[])new String[]{"\\(parse[d] later\\) <.+>"});
    }
}

