/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.nbt.nbtapi;

import com.leaf.nbt.nbtapi.NBTCompoundList;
import com.leaf.nbt.nbtapi.NBTItem;
import com.leaf.nbt.nbtapi.NBTList;
import com.leaf.nbt.nbtapi.NBTListCompound;
import com.leaf.nbt.nbtapi.NBTReflectionUtil;
import com.leaf.nbt.nbtapi.NBTType;
import com.leaf.nbt.nbtapi.NbtApiException;
import com.leaf.nbt.nbtapi.utils.MinecraftVersion;
import com.leaf.nbt.nbtapi.utils.nmsmappings.ReflectionMethod;
import java.io.OutputStream;
import java.util.Set;
import org.bukkit.inventory.ItemStack;

public class NBTCompound {
    private String compundName;
    private NBTCompound parent;

    protected NBTCompound(NBTCompound owner, String name) {
        this.compundName = name;
        this.parent = owner;
    }

    protected void saveCompound() {
        if (this.parent != null) {
            this.parent.saveCompound();
        }
    }

    public String getName() {
        return this.compundName;
    }

    public Object getCompound() {
        return this.parent.getCompound();
    }

    protected void setCompound(Object compound) {
        this.parent.setCompound(compound);
    }

    public NBTCompound getParent() {
        return this.parent;
    }

    public void mergeCompound(NBTCompound comp) {
        NBTReflectionUtil.mergeOtherNBTCompound(this, comp);
        this.saveCompound();
    }

    public void setString(String key, String value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_STRING, key, value);
        this.saveCompound();
    }

    public String getString(String key) {
        return (String)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_STRING, key);
    }

    protected String getContent(String key) {
        return NBTReflectionUtil.getContent(this, key);
    }

    public void setInteger(String key, Integer value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INT, key, value);
        this.saveCompound();
    }

    public Integer getInteger(String key) {
        return (Integer)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INT, key);
    }

    public void setDouble(String key, Double value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_DOUBLE, key, value);
        this.saveCompound();
    }

    public Double getDouble(String key) {
        return (Double)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_DOUBLE, key);
    }

    public void setByte(String key, Byte value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTE, key, value);
        this.saveCompound();
    }

    public Byte getByte(String key) {
        return (Byte)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTE, key);
    }

    public void setShort(String key, Short value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_SHORT, key, value);
        this.saveCompound();
    }

    public Short getShort(String key) {
        return (Short)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_SHORT, key);
    }

    public void setLong(String key, Long value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_LONG, key, value);
        this.saveCompound();
    }

    public Long getLong(String key) {
        return (Long)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_LONG, key);
    }

    public void setFloat(String key, Float value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_FLOAT, key, value);
        this.saveCompound();
    }

    public Float getFloat(String key) {
        return (Float)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_FLOAT, key);
    }

    public void setByteArray(String key, byte[] value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTEARRAY, key, value);
        this.saveCompound();
    }

    public byte[] getByteArray(String key) {
        return (byte[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTEARRAY, key);
    }

    public void setIntArray(String key, int[] value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INTARRAY, key, value);
        this.saveCompound();
    }

    public int[] getIntArray(String key) {
        return (int[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INTARRAY, key);
    }

    public void setBoolean(String key, Boolean value) {
        NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BOOLEAN, key, value);
        this.saveCompound();
    }

    protected void set(String key, Object val) {
        NBTReflectionUtil.set(this, key, val);
        this.saveCompound();
    }

    public Boolean getBoolean(String key) {
        return (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BOOLEAN, key);
    }

    public void setObject(String key, Object value) {
        NBTReflectionUtil.setObject(this, key, value);
        this.saveCompound();
    }

    public <T> T getObject(String key, Class<T> type) {
        return NBTReflectionUtil.getObject(this, key, type);
    }

    public void setItemStack(String key, ItemStack item) {
        this.removeKey(key);
        this.addCompound(key).mergeCompound(NBTItem.convertItemtoNBT(item));
    }

    public ItemStack getItemStack(String key) {
        NBTCompound comp = this.getCompound(key);
        return NBTItem.convertNBTtoItem(comp);
    }

    public Boolean hasKey(String key) {
        Boolean b = (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_HAS_KEY, key);
        if (b == null) {
            return false;
        }
        return b;
    }

    public void removeKey(String key) {
        NBTReflectionUtil.remove(this, key);
        this.saveCompound();
    }

    public Set<String> getKeys() {
        return NBTReflectionUtil.getKeys(this);
    }

    public NBTCompound addCompound(String name) {
        if (this.getType(name) == NBTType.NBTTagCompound) {
            return this.getCompound(name);
        }
        NBTReflectionUtil.addNBTTagCompound(this, name);
        NBTCompound comp = this.getCompound(name);
        if (comp == null) {
            throw new NbtApiException("Error while adding Compound, got null!");
        }
        this.saveCompound();
        return comp;
    }

    public NBTCompound getCompound(String name) {
        if (this.getType(name) != NBTType.NBTTagCompound) {
            return null;
        }
        NBTCompound next = new NBTCompound(this, name);
        if (NBTReflectionUtil.valideCompound(next).booleanValue()) {
            return next;
        }
        return null;
    }

    public NBTList<String> getStringList(String name) {
        NBTList<String> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagString, String.class);
        this.saveCompound();
        return list;
    }

    public NBTList<Integer> getIntegerList(String name) {
        NBTList<Integer> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagInt, Integer.class);
        this.saveCompound();
        return list;
    }

    public NBTList<Float> getFloatList(String name) {
        NBTList<Float> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagFloat, Float.class);
        this.saveCompound();
        return list;
    }

    public NBTList<Double> getDoubleList(String name) {
        NBTList<Double> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagDouble, Double.class);
        this.saveCompound();
        return list;
    }

    public NBTList<Long> getLongList(String name) {
        NBTList<Long> list = NBTReflectionUtil.getList(this, name, NBTType.NBTTagLong, Long.class);
        this.saveCompound();
        return list;
    }

    public NBTCompoundList getCompoundList(String name) {
        NBTCompoundList list = (NBTCompoundList)NBTReflectionUtil.getList(this, name, NBTType.NBTTagCompound, NBTListCompound.class);
        this.saveCompound();
        return list;
    }

    public NBTType getType(String name) {
        if (MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
            return null;
        }
        Object o = NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_TYPE, name);
        if (o == null) {
            return null;
        }
        return NBTType.valueOf(((Byte)o).byteValue());
    }

    public void writeCompound(OutputStream stream) {
        NBTReflectionUtil.writeApiNBT(this, stream);
    }

    public String toString() {
        return this.asNBTString();
    }

    @Deprecated
    public String toString(String key) {
        return this.asNBTString();
    }

    @Deprecated
    public String asNBTString() {
        Object comp = NBTReflectionUtil.gettoCompount(this.getCompound(), this);
        if (comp == null) {
            return "{}";
        }
        return comp.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

