/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.db;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.leaf.Leaf;
import com.leaf.db.ExprUnsafe;
import com.leaf.util.SkriptUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import javax.sql.rowset.CachedRowSet;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class EffExecuteStatement
extends Delay {
    static String lastError;
    private static final ExecutorService threadPool;
    private Expression<String> query;
    private Expression<HikariDataSource> dataSource;
    private VariableString var;
    private boolean isLocal;
    private boolean isList;
    private boolean isSync;

    private void continueScriptExecution(Event e, String res) {
        lastError = res;
        if (this.getNext() != null) {
            TriggerItem.walk((TriggerItem)this.getNext(), (Event)e);
        }
    }

    protected void execute(Event e) {
        boolean isMainThread = Bukkit.isPrimaryThread();
        if (this.isSync && !isMainThread) {
            String result = this.executeStatement(e);
            this.continueScriptExecution(e, result);
        } else {
            if (this.isSync) {
                Skript.warning((String)"A SQL query was attempted on the main thread!");
            }
            CompletableFuture<String> sql = CompletableFuture.supplyAsync(() -> this.executeStatement(e), threadPool);
            sql.whenComplete((res, err) -> {
                if (err != null) {
                    err.printStackTrace();
                }
                Bukkit.getScheduler().runTask((Plugin)Leaf.getInstance(), () -> this.continueScriptExecution(e, (String)res));
            });
        }
    }

    protected TriggerItem walk(Event e) {
        this.debug(e, true);
        SkriptUtil.delay(e);
        this.execute(e);
        return null;
    }

    private String executeStatement(Event e) {
        HikariDataSource ds = (HikariDataSource)this.dataSource.getSingle(e);
        if (ds == null) {
            return "Data source is not set";
        }
        try (Connection conn = ds.getConnection();
             PreparedStatement stmt = this.createStatement(e, conn);){
            boolean hasResultSet = stmt.execute();
            if (this.var != null) {
                String baseVariable = this.var.toString(e).toLowerCase(Locale.ENGLISH);
                if (this.isList) {
                    baseVariable = baseVariable.substring(0, baseVariable.length() - 1);
                }
                if (hasResultSet) {
                    CachedRowSet crs = Leaf.getRowSetFactory().createCachedRowSet();
                    crs.populate(stmt.getResultSet());
                    if (this.isList) {
                        this.populateVariable(e, crs, baseVariable);
                    } else {
                        crs.last();
                        this.setVariable(e, baseVariable, crs.getRow());
                    }
                } else if (!this.isList) {
                    this.setVariable(e, baseVariable, stmt.getUpdateCount());
                }
            }
        }
        catch (SQLException ex) {
            return ex.getMessage();
        }
        return null;
    }

    private PreparedStatement createStatement(Event e, Connection conn) throws SQLException {
        if (!(this.query instanceof VariableString)) {
            return conn.prepareStatement((String)this.query.getSingle(e));
        }
        if (((VariableString)this.query).isSimple()) {
            return conn.prepareStatement(SkriptUtil.getSimpleString((VariableString)this.query));
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        Object[] objects = SkriptUtil.getTemplateString((VariableString)this.query);
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            if (o instanceof String) {
                sb.append(o);
                continue;
            }
            Expression<?> expr = SkriptUtil.getExpressionFromInfo(o);
            String before = this.getString(objects, i - 1);
            String after = this.getString(objects, i + 1);
            boolean standaloneString = false;
            if (before != null && after != null && before.endsWith("'") && after.endsWith("'")) {
                standaloneString = true;
            }
            Object expressionValue = expr.getSingle(e);
            if (expr instanceof ExprUnsafe) {
                sb.append(expressionValue);
                if (!standaloneString || !(expressionValue instanceof String)) continue;
                String rawExpression = ((ExprUnsafe)expr).getRawExpression();
                Skript.warning((String)String.format("Unsafe may have been used unnecessarily. Try replacing 'unsafe %1$s' with %1$s", rawExpression));
                continue;
            }
            parameters.add(expressionValue);
            sb.append('?');
            if (!standaloneString) continue;
            Skript.warning((String)"Do not surround expressions with quotes!");
        }
        PreparedStatement stmt = conn.prepareStatement(sb.toString());
        for (int i = 0; i < parameters.size(); ++i) {
            stmt.setObject(i + 1, parameters.get(i));
        }
        return stmt;
    }

    private String getString(Object[] objects, int index) {
        if (index < 0 || index >= objects.length) {
            return null;
        }
        Object object = objects[index];
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private void setVariable(Event e, String name, Object obj) {
        Variables.setVariable((String)name.toLowerCase(Locale.ENGLISH), (Object)obj, (Event)e, (boolean)this.isLocal);
    }

    private void populateVariable(Event e, CachedRowSet crs, String baseVariable) throws SQLException {
        ResultSetMetaData meta = crs.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String label = meta.getColumnLabel(i);
            this.setVariable(e, baseVariable + label, label);
        }
        int rowNumber = 1;
        while (crs.next()) {
            for (int i = 1; i <= columnCount; ++i) {
                this.setVariable(e, baseVariable + meta.getColumnLabel(i).toLowerCase(Locale.ENGLISH) + "::" + rowNumber, crs.getObject(i));
            }
            ++rowNumber;
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "execute " + this.query.toString(e, debug) + " in " + this.dataSource.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression<?> statementExpr = exprs[0];
        if (!(statementExpr instanceof VariableString) && !(statementExpr instanceof ExprUnsafe)) {
            Skript.error((String)"Database statements must be string literals. If you must use an expression, you may use \"%unsafe (your expression)%\", but keep in mind, you may be vulnerable to SQL injection attacks!");
            return false;
        }
        this.query = statementExpr;
        this.dataSource = exprs[1];
        Expression<?> expr = exprs[2];
        boolean bl = this.isSync = parseResult.mark == 1;
        if (expr instanceof Variable) {
            Variable varExpr = (Variable)expr;
            this.var = SkriptUtil.getVariableName(varExpr);
            this.isLocal = varExpr.isLocal();
            this.isList = varExpr.isList();
        } else if (expr != null) {
            Skript.error((String)(expr + " is not a variable"));
            return false;
        }
        return true;
    }

    static {
        Skript.registerEffect(EffExecuteStatement.class, (String[])new String[]{"[(1\u00a6synchronously)] execute %string% (in|on) %datasource% [and store [[the] (output|result)[s]] (to|in) [the] [var[iable]] %-objects%]"});
        threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }
}

