/*
 * Decompiled with CFR 0.152.
 */
package org.codemc.worldguardwrapper.implementation.legacy;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.codemc.worldguardwrapper.flag.IWrappedFlag;
import org.codemc.worldguardwrapper.implementation.IWorldGuardImplementation;
import org.codemc.worldguardwrapper.implementation.legacy.flag.AbstractWrappedFlag;
import org.codemc.worldguardwrapper.implementation.legacy.region.WrappedRegion;
import org.codemc.worldguardwrapper.implementation.legacy.utility.WorldGuardFlagUtilities;
import org.codemc.worldguardwrapper.implementation.legacy.utility.WorldGuardVectorUtilities;
import org.codemc.worldguardwrapper.region.IWrappedRegion;

public class WorldGuardImplementation
implements IWorldGuardImplementation {
    private final WorldGuardPlugin plugin = WorldGuardPlugin.inst();

    private Optional<LocalPlayer> wrapPlayer(Player player) {
        return Optional.ofNullable(player).map(bukkitPlayer -> this.plugin.wrapPlayer(player));
    }

    private Optional<RegionManager> getWorldManager(@NonNull World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return Optional.ofNullable(this.plugin.getRegionManager(world));
    }

    private Optional<ApplicableRegionSet> getApplicableRegions(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return this.getWorldManager(location.getWorld()).map(manager -> manager.getApplicableRegions(location));
    }

    private Optional<ApplicableRegionSet> getApplicableRegions(@NonNull Location minimum, @NonNull Location maximum) {
        if (minimum == null) {
            throw new NullPointerException("minimum is marked non-null but is null");
        }
        if (maximum == null) {
            throw new NullPointerException("maximum is marked non-null but is null");
        }
        return this.getWorldManager(minimum.getWorld()).map(manager -> manager.getApplicableRegions((ProtectedRegion)new ProtectedCuboidRegion("temp", WorldGuardVectorUtilities.toBlockVector(minimum), WorldGuardVectorUtilities.toBlockVector(maximum))));
    }

    private <V> Optional<V> queryValue(Player player, @NonNull Location location, @NonNull Flag<V> flag) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return this.getApplicableRegions(location).map(applicableRegions -> applicableRegions.queryValue((RegionAssociable)this.wrapPlayer(player).orElse(null), flag));
    }

    @Override
    public JavaPlugin getWorldGuardPlugin() {
        return WorldGuardPlugin.inst();
    }

    @Override
    public int getApiVersion() {
        return -6;
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> getFlag(String name, Class<T> type) {
        for (Flag currentFlag : DefaultFlag.getFlags()) {
            if (!currentFlag.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(WorldGuardFlagUtilities.wrap(currentFlag, type));
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> queryFlag(Player player, Location location, IWrappedFlag<T> flag) {
        AbstractWrappedFlag wrappedFlag = (AbstractWrappedFlag)flag;
        return this.queryValue(player, location, wrappedFlag.getHandle()).flatMap(value -> wrappedFlag.fromWGValue(value));
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> registerFlag(String name, Class<T> type, T defaultValue) {
        throw new UnsupportedOperationException("Custom flags aren't supported in this version of WorldGuard!");
    }

    @Override
    public Optional<IWrappedRegion> getRegion(World world, String id) {
        return this.getWorldManager(world).map(regionManager -> regionManager.getRegion(id)).map(region -> new WrappedRegion(world, (ProtectedRegion)region));
    }

    @Override
    public Map<String, IWrappedRegion> getRegions(World world) {
        RegionManager regionManager = this.plugin.getRegionManager(world);
        Map regions = regionManager.getRegions();
        HashMap<String, IWrappedRegion> map = new HashMap<String, IWrappedRegion>();
        regions.forEach((name, region) -> {
            IWrappedRegion cfr_ignored_0 = map.put((String)name, new WrappedRegion(world, (ProtectedRegion)region));
        });
        return map;
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location location) {
        ApplicableRegionSet regionSet = this.getApplicableRegions(location).orElse(null);
        HashSet<IWrappedRegion> set = new HashSet<IWrappedRegion>();
        if (regionSet == null) {
            return set;
        }
        regionSet.forEach(region -> set.add(new WrappedRegion(location.getWorld(), (ProtectedRegion)region)));
        return set;
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location minimum, Location maximum) {
        ApplicableRegionSet regionSet = this.getApplicableRegions(minimum, maximum).orElse(null);
        HashSet<IWrappedRegion> set = new HashSet<IWrappedRegion>();
        if (regionSet == null) {
            return set;
        }
        regionSet.forEach(region -> set.add(new WrappedRegion(minimum.getWorld(), (ProtectedRegion)region)));
        return set;
    }

    @Override
    public Optional<IWrappedRegion> addRegion(String id, List<Location> points, int minY, int maxY) {
        World world = points.get(0).getWorld();
        Object region = points.size() == 2 ? new ProtectedCuboidRegion(id, WorldGuardVectorUtilities.toBlockVector(points.get(0)), WorldGuardVectorUtilities.toBlockVector(points.get(1))) : new ProtectedPolygonalRegion(id, WorldGuardVectorUtilities.toBlockVector2DList(points), minY, maxY);
        Optional<RegionManager> manager = this.getWorldManager(world);
        if (manager.isPresent()) {
            manager.get().addRegion((ProtectedRegion)region);
            return Optional.of(new WrappedRegion(world, (ProtectedRegion)region));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Set<IWrappedRegion>> removeRegion(World world, String id) {
        Optional<Set> set = this.getWorldManager(world).map(manager -> manager.removeRegion(id));
        return set.map(protectedRegions -> protectedRegions.stream().map(region -> new WrappedRegion(world, (ProtectedRegion)region)).collect(Collectors.toSet()));
    }
}

