/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.nms.v1_15_R1;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.List;
import net.jitse.npclib.NPCLib;
import net.jitse.npclib.api.skin.Skin;
import net.jitse.npclib.api.state.NPCSlot;
import net.jitse.npclib.hologram.Hologram;
import net.jitse.npclib.internal.MinecraftVersion;
import net.jitse.npclib.internal.NPCBase;
import net.jitse.npclib.nms.v1_15_R1.packets.PacketPlayOutEntityHeadRotationWrapper;
import net.jitse.npclib.nms.v1_15_R1.packets.PacketPlayOutEntityMetadataWrapper;
import net.jitse.npclib.nms.v1_15_R1.packets.PacketPlayOutNamedEntitySpawnWrapper;
import net.jitse.npclib.nms.v1_15_R1.packets.PacketPlayOutPlayerInfoWrapper;
import net.jitse.npclib.nms.v1_15_R1.packets.PacketPlayOutScoreboardTeamWrapper;
import net.minecraft.server.v1_15_R1.EnumItemSlot;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_15_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_15_R1.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_15_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_15_R1.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_15_R1.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_15_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_15_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NPC_v1_15_R1
extends NPCBase {
    private PacketPlayOutNamedEntitySpawn packetPlayOutNamedEntitySpawn;
    private PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeamRegister;
    private PacketPlayOutPlayerInfo packetPlayOutPlayerInfoAdd;
    private PacketPlayOutPlayerInfo packetPlayOutPlayerInfoRemove;
    private PacketPlayOutEntityHeadRotation packetPlayOutEntityHeadRotation;
    private PacketPlayOutEntityDestroy packetPlayOutEntityDestroy;

    public NPC_v1_15_R1(NPCLib instance, List<String> lines) {
        super(instance, lines);
    }

    @Override
    public void createPackets() {
        this.hologram = new Hologram(MinecraftVersion.V1_15_R1, this.location.clone().add(0.0, 0.5, 0.0), this.text);
        PacketPlayOutPlayerInfoWrapper packetPlayOutPlayerInfoWrapper = new PacketPlayOutPlayerInfoWrapper();
        this.packetPlayOutScoreboardTeamRegister = new PacketPlayOutScoreboardTeamWrapper().createRegisterTeam(this.name);
        this.packetPlayOutPlayerInfoAdd = packetPlayOutPlayerInfoWrapper.create(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, this.gameProfile, this.name);
        this.packetPlayOutNamedEntitySpawn = new PacketPlayOutNamedEntitySpawnWrapper().create(this.uuid, this.location, this.entityId);
        this.packetPlayOutEntityHeadRotation = new PacketPlayOutEntityHeadRotationWrapper().create(this.location, this.entityId);
        this.packetPlayOutPlayerInfoRemove = packetPlayOutPlayerInfoWrapper.create(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, this.gameProfile, this.name);
        this.packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.entityId});
    }

    @Override
    public void sendShowPackets(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        if (this.hasTeamRegistered.add(player.getUniqueId())) {
            playerConnection.sendPacket((Packet)this.packetPlayOutScoreboardTeamRegister);
        }
        playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoAdd);
        playerConnection.sendPacket((Packet)this.packetPlayOutNamedEntitySpawn);
        playerConnection.sendPacket((Packet)this.packetPlayOutEntityHeadRotation);
        this.sendMetadataPacket(player);
        this.hologram.show(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.instance.getPlugin(), () -> playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoRemove), 200L);
    }

    @Override
    public void sendHidePackets(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        playerConnection.sendPacket((Packet)this.packetPlayOutEntityDestroy);
        playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoRemove);
        this.hologram.hide(player);
    }

    @Override
    public void sendMetadataPacket(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadataWrapper().create(this.activeStates, this.entityId);
        playerConnection.sendPacket((Packet)packet);
    }

    @Override
    public void sendEquipmentPacket(Player player, NPCSlot slot, boolean auto) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        EnumItemSlot nmsSlot = slot.getNmsEnum(EnumItemSlot.class);
        ItemStack item = this.getItem(slot);
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(this.entityId, nmsSlot, CraftItemStack.asNMSCopy((ItemStack)item));
        playerConnection.sendPacket((Packet)packet);
    }

    @Override
    public void updateSkin(Skin skin) {
        GameProfile newProfile = new GameProfile(this.uuid, this.name);
        newProfile.getProperties().get((Object)"textures").clear();
        newProfile.getProperties().put((Object)"textures", (Object)new Property("textures", skin.getValue(), skin.getSignature()));
        this.packetPlayOutPlayerInfoAdd = new PacketPlayOutPlayerInfoWrapper().create(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, newProfile, this.name);
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
            playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoRemove);
            playerConnection.sendPacket((Packet)this.packetPlayOutEntityDestroy);
            playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoAdd);
            playerConnection.sendPacket((Packet)this.packetPlayOutNamedEntitySpawn);
        }
    }
}

