/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml.utils.yaml;

import ch.njol.skript.util.Date;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.WeatherType;
import com.leaf.yaml.api.ConstructedClass;
import com.leaf.yaml.utils.yaml.SkriptClass;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.util.Vector;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class SkriptYamlConstructor
extends SafeConstructor {
    private static final Pattern TIMESTAMP_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(?:Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$");
    private static final Pattern YMD_REGEXP = Pattern.compile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$");

    public SkriptYamlConstructor() {
        this.yamlConstructors.put(new Tag("!skriptclass"), new ConstructSkriptClass());
        this.yamlConstructors.put(new Tag("!vector"), new ConstructVector());
        this.yamlConstructors.put(new Tag("!location"), new ConstructLocation());
        this.yamlConstructors.put(new Tag("!skriptdate"), new ConstructSkriptDate());
        this.yamlConstructors.put(new Tag("!skripttime"), new ConstructSkriptTime());
        this.yamlConstructors.put(new Tag("!skripttimespan"), new ConstructSkriptTimespan());
        this.yamlConstructors.put(new Tag("!skriptcolor"), new ConstructSkriptColor());
        this.yamlConstructors.put(new Tag("!skriptweather"), new ConstructSkriptWeather());
        this.yamlConstructors.put(Tag.MAP, new ConstructCustomObject());
    }

    public void register(String tag, ConstructedClass<?> cc) {
        this.yamlConstructors.put(new Tag("!" + tag), cc);
    }

    public Map<Object, Object> constructMap(MappingNode node) {
        return this.constructMapping(node);
    }

    private class ConstructSkriptClass
    extends AbstractConstruct {
        private ConstructSkriptClass() {
        }

        public Object construct(Node node) {
            Map values = SkriptYamlConstructor.this.constructMapping((MappingNode)node);
            String type = (String)values.get("type");
            String data = (String)values.get("data");
            if (type == null || data == null) {
                return null;
            }
            return new SkriptClass(type, data).deserialize();
        }
    }

    private class ConstructVector
    extends AbstractConstruct {
        private ConstructVector() {
        }

        public Object construct(Node node) {
            Map values = SkriptYamlConstructor.this.constructMapping((MappingNode)node);
            Double x = (Double)values.get("x");
            Double y = (Double)values.get("y");
            Double z = (Double)values.get("z");
            if (x == null || y == null || z == null) {
                return null;
            }
            return new Vector(x.doubleValue(), y.doubleValue(), z.doubleValue());
        }
    }

    private class ConstructLocation
    extends AbstractConstruct {
        private ConstructLocation() {
        }

        public Object construct(Node node) {
            Map values = SkriptYamlConstructor.this.constructMapping((MappingNode)node);
            String w = (String)values.get("world");
            Double x = (Double)values.get("x");
            Double y = (Double)values.get("y");
            Double z = (Double)values.get("z");
            Double yaw = (Double)values.get("yaw");
            Double pitch = (Double)values.get("pitch");
            if (w == null | x == null || y == null || z == null || yaw == null || pitch == null) {
                return null;
            }
            return new Location(Bukkit.getServer().getWorld(w), x.doubleValue(), y.doubleValue(), z.doubleValue(), (float)yaw.doubleValue(), (float)pitch.doubleValue());
        }
    }

    public static class ConstructSkriptDate
    extends AbstractConstruct {
        private Calendar calendar;

        public Calendar getCalendar() {
            return this.calendar;
        }

        public Object construct(Node node) {
            TimeZone timeZone;
            ScalarNode scalar = (ScalarNode)node;
            String nodeValue = scalar.getValue();
            Matcher match = YMD_REGEXP.matcher(nodeValue);
            if (match.matches()) {
                String year_s = match.group(1);
                String month_s = match.group(2);
                String day_s = match.group(3);
                this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                this.calendar.clear();
                this.calendar.set(1, Integer.parseInt(year_s));
                this.calendar.set(2, Integer.parseInt(month_s) - 1);
                this.calendar.set(5, Integer.parseInt(day_s));
                return new Date(this.calendar.getTime().getTime());
            }
            match = TIMESTAMP_REGEXP.matcher(nodeValue);
            if (!match.matches()) {
                throw new YAMLException("Unexpected timestamp: " + nodeValue);
            }
            String year_s = match.group(1);
            String month_s = match.group(2);
            String day_s = match.group(3);
            String hour_s = match.group(4);
            String min_s = match.group(5);
            String seconds = match.group(6);
            String millis = match.group(7);
            if (millis != null) {
                seconds = seconds + "." + millis;
            }
            double fractions = Double.parseDouble(seconds);
            int sec_s = (int)Math.round(Math.floor(fractions));
            int usec = (int)Math.round((fractions - (double)sec_s) * 1000.0);
            String timezoneh_s = match.group(8);
            String timezonem_s = match.group(9);
            if (timezoneh_s != null) {
                String time = timezonem_s != null ? ":" + timezonem_s : "00";
                timeZone = TimeZone.getTimeZone("GMT" + timezoneh_s + time);
            } else {
                timeZone = TimeZone.getTimeZone("UTC");
            }
            this.calendar = Calendar.getInstance(timeZone);
            this.calendar.set(1, Integer.parseInt(year_s));
            this.calendar.set(2, Integer.parseInt(month_s) - 1);
            this.calendar.set(5, Integer.parseInt(day_s));
            this.calendar.set(11, Integer.parseInt(hour_s));
            this.calendar.set(12, Integer.parseInt(min_s));
            this.calendar.set(13, sec_s);
            this.calendar.set(14, usec);
            return new Date(this.calendar.getTime().getTime());
        }
    }

    public static class ConstructSkriptTime
    extends AbstractConstruct {
        public Object construct(Node node) {
            ScalarNode scalar = (ScalarNode)node;
            String nodeValue = scalar.getValue();
            return Time.parse((String)nodeValue);
        }
    }

    public static class ConstructSkriptTimespan
    extends AbstractConstruct {
        public Object construct(Node node) {
            ScalarNode scalar = (ScalarNode)node;
            String nodeValue = scalar.getValue();
            return Timespan.parse((String)nodeValue);
        }
    }

    public static class ConstructSkriptColor
    extends AbstractConstruct {
        public Object construct(Node node) {
            ScalarNode scalar = (ScalarNode)node;
            String nodeValue = scalar.getValue();
            return ChatColor.valueOf((String)nodeValue);
        }
    }

    public static class ConstructSkriptWeather
    extends AbstractConstruct {
        public Object construct(Node node) {
            ScalarNode scalar = (ScalarNode)node;
            String nodeValue = scalar.getValue();
            return WeatherType.parse((String)nodeValue);
        }
    }

    private class ConstructCustomObject
    extends SafeConstructor.ConstructYamlMap {
        private ConstructCustomObject() {
            super((SafeConstructor)SkriptYamlConstructor.this);
        }

        public Object construct(Node node) {
            if (node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
            }
            Map raw = (Map)super.construct(node);
            if (raw.containsKey("==")) {
                LinkedHashMap typed = new LinkedHashMap(raw.size());
                for (Map.Entry entry : raw.entrySet()) {
                    typed.put(entry.getKey().toString(), entry.getValue());
                }
                try {
                    return ConfigurationSerialization.deserializeObject(typed);
                }
                catch (IllegalArgumentException ex) {
                    throw new YAMLException("Could not deserialize object", (Throwable)ex);
                }
            }
            return raw;
        }

        public void construct2ndStep(Node node, Object object) {
            throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
        }
    }
}

