/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.leaf.Leaf;
import com.leaf.yaml.utils.SkriptYamlUtils;
import com.leaf.yaml.utils.StringUtil;
import com.leaf.yaml.utils.yaml.YAMLFormat;
import com.leaf.yaml.utils.yaml.YAMLProcessor;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Load all YAML from directory")
@Description(value={"Loads a directory YAML files into memory.\n  - The input is a directory (ie. \"plugins/MyAwesomePlugin/\").\n  - If for example a file in that directory is named test.yml then the output ID would be 'plugins/MyAwesomePlugin/test.yml'\n  - Using the optional filename ID would output `test.yml`"})
@Examples(value={"#This isn't something you would really want to do, or is it?", "load all yaml from directory \"/plugins/skript-yaml/test\"", "loop all of the currently loaded yaml files:", "\tloop yaml nodes \"\" from loop-value-1:", "\t\tloop yaml nodes loop-value-2 from loop-value-1:", "\t\t\tbroadcast yaml value \"%loop-value-2%.%loop-value-3%\" from loop-value-1"})
@Since(value="1.2")
public class EffLoadYamlDirectory
extends Effect {
    private Expression<String> directories;
    private int mark;
    private int matchedPattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(@Nullable Event event) {
        for (String name : (String[])this.directories.getAll(event)) {
            for (File yamlFile : SkriptYamlUtils.directoryFilter(StringUtil.checkSeparator(name), this.mark == 1, "Load")) {
                YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
                try {
                    yaml.load();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (this.matchedPattern == 1) {
                        Leaf.YAML_STORE.put(StringUtil.stripExtention(yamlFile.getName()), yaml);
                    } else {
                        Leaf.YAML_STORE.put(StringUtil.checkLastSeparator(name) + yamlFile.getName(), yaml);
                    }
                }
            }
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "[re]load all yaml from director(y|ies) " + this.directories.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.directories = exprs[0];
        this.mark = parse.mark;
        this.matchedPattern = matchedPattern;
        return true;
    }

    static {
        Skript.registerEffect(EffLoadYamlDirectory.class, (String[])new String[]{"[re]load all [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings%", "[re]load all [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings% using [the] filename as [the] id"});
    }
}

