/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.skriptmirror.util;

import ch.njol.skript.Skript;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public final class JavaUtil {
    public static final Map<Class<?>, Class<?>> WRAPPER_CLASSES = new HashMap();
    public static final Set<Class<?>> NUMERIC_CLASSES = new HashSet();
    public static final Map<String, Class<?>> PRIMITIVE_CLASS_NAMES = new HashMap();

    public static Stream<Field> fields(Class<?> cls) {
        return Stream.concat(Arrays.stream(cls.getFields()), Arrays.stream(cls.getDeclaredFields())).distinct();
    }

    public static Stream<Method> methods(Class<?> cls) {
        return Stream.concat(Arrays.stream(cls.getMethods()), Arrays.stream(cls.getDeclaredMethods())).distinct();
    }

    public static Stream<Constructor> constructors(Class<?> cls) {
        return Arrays.stream(cls.getDeclaredConstructors());
    }

    public static String toGenericString(Member o) {
        if (o instanceof Field) {
            return ((Field)o).toGenericString();
        }
        if (o instanceof Method) {
            return ((Method)o).toGenericString();
        }
        if (o instanceof Constructor) {
            return ((Constructor)o).toGenericString();
        }
        return null;
    }

    public static Object boxPrimitiveArray(Object obj) {
        Class<?> componentType = obj.getClass().getComponentType();
        if (componentType != null && componentType.isPrimitive()) {
            int length = Array.getLength(obj);
            ?[] boxedArray = JavaUtil.newArray(WRAPPER_CLASSES.get(componentType), length);
            for (int i = 0; i < length; ++i) {
                boxedArray[i] = Array.get(obj, i);
            }
            obj = boxedArray;
        }
        return obj;
    }

    public static Object convertNumericArray(Object array, Class<?> to) {
        Object newArray;
        Class<?> componentType = array.getClass().getComponentType();
        int length = Array.getLength(array);
        if (componentType.isArray()) {
            newArray = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Object innerArray = Array.get(array, i);
                if (innerArray == null) {
                    innerArray = Array.newInstance(componentType.getComponentType(), 0);
                    Array.set(newArray, i, innerArray);
                    continue;
                }
                Array.set(newArray, i, JavaUtil.convertNumericArray(innerArray, to));
            }
        } else {
            newArray = Array.newInstance(to, length);
            for (int i = 0; i < length; ++i) {
                Object what = Array.get(array, i);
                if (to == Byte.TYPE || to == Byte.class) {
                    what = ((Number)what).byteValue();
                } else if (to == Double.TYPE || to == Double.class) {
                    what = ((Number)what).doubleValue();
                } else if (to == Float.TYPE || to == Float.class) {
                    what = Float.valueOf(((Number)what).floatValue());
                } else if (to == Integer.TYPE || to == Integer.class) {
                    what = ((Number)what).intValue();
                } else if (to == Long.TYPE || to == Long.class) {
                    what = ((Number)what).longValue();
                } else if (to == Short.TYPE || to == Short.class) {
                    what = ((Number)what).shortValue();
                }
                Array.set(newArray, i, what);
            }
        }
        return newArray;
    }

    public static int getArrayDepth(Class<?> cls) {
        int depth = 0;
        while (cls.isArray()) {
            cls = cls.getComponentType();
            ++depth;
        }
        return depth;
    }

    public static Class<?> getBaseComponent(Class<?> obj) {
        Class<?> componentType = obj.getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }

    public static <T, R> Function<T, R> propagateErrors(ExceptionalFunction<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception e) {
                Skript.warning((String)String.format("skript-mirror encountered a %s: %s%nRun Skript with the verbosity 'very high' for the stack trace.", e.getClass().getSimpleName(), e.getMessage()));
                if (Skript.logVeryHigh()) {
                    StringWriter errors = new StringWriter();
                    e.printStackTrace(new PrintWriter(errors));
                    Skript.warning((String)errors.toString());
                }
                return null;
            }
        };
    }

    public static boolean isNumericClass(Class<?> cls) {
        return Number.class.isAssignableFrom(cls) || NUMERIC_CLASSES.contains(cls);
    }

    public static <T> T[] newArray(Class<? extends T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> Class<?> getArrayClass(Class<T> type) {
        return Array.newInstance(type, 0).getClass();
    }

    public static Class<?> getArrayClass(Class<?> type, int layers) {
        for (int i = 0; i < layers; ++i) {
            type = JavaUtil.getArrayClass(type);
        }
        return type;
    }

    static {
        WRAPPER_CLASSES.put(Boolean.TYPE, Boolean.class);
        WRAPPER_CLASSES.put(Byte.TYPE, Byte.class);
        WRAPPER_CLASSES.put(Character.TYPE, Character.class);
        WRAPPER_CLASSES.put(Double.TYPE, Double.class);
        WRAPPER_CLASSES.put(Float.TYPE, Float.class);
        WRAPPER_CLASSES.put(Integer.TYPE, Integer.class);
        WRAPPER_CLASSES.put(Long.TYPE, Long.class);
        WRAPPER_CLASSES.put(Short.TYPE, Short.class);
        NUMERIC_CLASSES.add(Byte.TYPE);
        NUMERIC_CLASSES.add(Double.TYPE);
        NUMERIC_CLASSES.add(Float.TYPE);
        NUMERIC_CLASSES.add(Integer.TYPE);
        NUMERIC_CLASSES.add(Long.TYPE);
        NUMERIC_CLASSES.add(Short.TYPE);
        PRIMITIVE_CLASS_NAMES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASS_NAMES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASS_NAMES.put("char", Character.TYPE);
        PRIMITIVE_CLASS_NAMES.put("double", Double.TYPE);
        PRIMITIVE_CLASS_NAMES.put("float", Float.TYPE);
        PRIMITIVE_CLASS_NAMES.put("int", Integer.TYPE);
        PRIMITIVE_CLASS_NAMES.put("long", Long.TYPE);
        PRIMITIVE_CLASS_NAMES.put("short", Short.TYPE);
    }

    @FunctionalInterface
    public static interface ExceptionalFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

