/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.skriptmirror.skript.custom.expression;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import com.leaf.skriptmirror.skript.custom.CustomSyntaxSection;
import com.leaf.skriptmirror.skript.custom.SyntaxParseEvent;
import com.leaf.skriptmirror.skript.custom.expression.CustomExpression;
import com.leaf.skriptmirror.skript.custom.expression.ExpressionChangeEvent;
import com.leaf.skriptmirror.skript.custom.expression.ExpressionGetEvent;
import com.leaf.skriptmirror.skript.custom.expression.ExpressionSyntaxInfo;
import com.leaf.skriptmirror.util.JavaUtil;
import com.leaf.skriptmirror.util.SkriptUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.regex.MatchResult;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CustomExpressionSection
extends CustomSyntaxSection<ExpressionSyntaxInfo> {
    private static CustomSyntaxSection.DataTracker<ExpressionSyntaxInfo> dataTracker;
    static Map<ExpressionSyntaxInfo, Class<?>> returnTypes;
    static Map<ExpressionSyntaxInfo, Trigger> expressionHandlers;
    static Map<ExpressionSyntaxInfo, Trigger> parserHandlers;
    static Map<ExpressionSyntaxInfo, Map<Changer.ChangeMode, Trigger>> changerHandlers;
    static Map<ExpressionSyntaxInfo, Map<Changer.ChangeMode, Class[]>> changerTypes;
    static Map<ExpressionSyntaxInfo, String> loopOfs;

    @Override
    protected CustomSyntaxSection.DataTracker<ExpressionSyntaxInfo> getDataTracker() {
        return dataTracker;
    }

    @Override
    protected boolean init(Literal[] args, int matchedPattern, SkriptParser.ParseResult parseResult, SectionNode node) {
        SectionNode patterns = (SectionNode)node.get("patterns");
        File script = (parseResult.mark & 2) == 2 ? SkriptUtil.getCurrentScript() : null;
        boolean alwaysPlural = (parseResult.mark & 1) == 1;
        switch (matchedPattern) {
            case 0: {
                String what = ((MatchResult)parseResult.regexes.get(0)).group();
                this.register(ExpressionSyntaxInfo.create(script, what, 1, alwaysPlural, false, false));
                break;
            }
            case 1: {
                if (patterns == null) {
                    Skript.error((String)"Custom expressions without inline patterns must have a patterns section.");
                    return false;
                }
                int i = 1;
                for (Node subNode : patterns) {
                    this.register(ExpressionSyntaxInfo.create(script, subNode.getKey(), i++, alwaysPlural, false, false));
                }
                break;
            }
            case 2: {
                String what = ((MatchResult)parseResult.regexes.get(0)).group();
                String fromType = Arrays.stream((ClassInfo[])args[0].getArray()).map(ClassInfo::getCodeName).map(codeName -> {
                    boolean isPlural = (Boolean)Utils.getEnglishPlural((String)codeName).getSecond();
                    if (!isPlural) {
                        return Utils.toEnglishPlural((String)codeName);
                    }
                    return codeName;
                }).collect(Collectors.joining("/"));
                if (!alwaysPlural) {
                    fromType = "$" + fromType;
                }
                this.register(ExpressionSyntaxInfo.create(script, "[the] " + what + " of %" + fromType + "%", 1, alwaysPlural, true, true));
                this.register(ExpressionSyntaxInfo.create(script, "%" + fromType + "%'[s] " + what, 1, alwaysPlural, false, true));
            }
        }
        if (matchedPattern != 1 && patterns != null) {
            Skript.error((String)"Custom expressions with inline patterns may not have a patterns section.");
            return false;
        }
        return CustomExpressionSection.handleEntriesAndSections(node, entryNode -> {
            String key = entryNode.getKey();
            if (key.equalsIgnoreCase("return type")) {
                String userReturnType = entryNode.getValue();
                Class returnType = Classes.getClassFromUserInput((String)ScriptLoader.replaceOptions((String)userReturnType));
                this.whichInfo.forEach(which -> returnTypes.put((ExpressionSyntaxInfo)which, returnType));
                return true;
            }
            if (key.equalsIgnoreCase("loop of")) {
                String loopOf = entryNode.getValue();
                this.whichInfo.forEach(which -> loopOfs.put((ExpressionSyntaxInfo)which, loopOf));
                return true;
            }
            return false;
        }, sectionNode -> {
            String key = sectionNode.getKey();
            if (key.equalsIgnoreCase("patterns")) {
                return true;
            }
            if (key.equalsIgnoreCase("get")) {
                ScriptLoader.setCurrentEvent((String)"custom expression getter", (Class[])new Class[]{ExpressionGetEvent.class});
                List<TriggerItem> items = SkriptUtil.getItemsFromNode(sectionNode);
                this.whichInfo.forEach(which -> expressionHandlers.put((ExpressionSyntaxInfo)which, new Trigger(SkriptUtil.getCurrentScript(), "get " + which.getPattern(), (SkriptEvent)this, items)));
                return true;
            }
            if (key.equalsIgnoreCase("parse")) {
                SyntaxParseEvent.register(this, sectionNode, this.whichInfo, parserHandlers);
                return true;
            }
            for (Changer.ChangeMode mode : Changer.ChangeMode.values()) {
                String name = mode.name().replace("_", " ").toLowerCase();
                if (!key.startsWith(name)) continue;
                String rawTypes = key.substring(name.length()).trim();
                ScriptLoader.setCurrentEvent((String)"custom expression changer", (Class[])new Class[]{ExpressionChangeEvent.class});
                List<TriggerItem> items = SkriptUtil.getItemsFromNode(sectionNode);
                this.whichInfo.forEach(which -> {
                    Map changerMap = changerHandlers.computeIfAbsent((ExpressionSyntaxInfo)which, k -> new HashMap());
                    changerMap.put(mode, new Trigger(SkriptUtil.getCurrentScript(), String.format("%s %s", name, which.getPattern()), (SkriptEvent)this, items));
                });
                if (rawTypes.length() > 0) {
                    Class[] acceptedClasses = (Class[])Arrays.stream(rawTypes.split(",")).map(String::trim).map(SkriptUtil::getUserClassInfoAndPlural).map(meta -> {
                        ClassInfo ci = (ClassInfo)meta.getFirst();
                        boolean plural = (Boolean)meta.getSecond();
                        if (plural) {
                            return JavaUtil.getArrayClass(ci.getC());
                        }
                        return ci.getC();
                    }).toArray(Class[]::new);
                    this.whichInfo.forEach(which -> changerTypes.computeIfAbsent((ExpressionSyntaxInfo)which, k -> new HashMap()).put(mode, acceptedClasses));
                }
                return true;
            }
            return false;
        });
    }

    public static ExpressionSyntaxInfo lookup(File script, int matchedPattern) {
        return dataTracker.lookup(script, matchedPattern);
    }

    static {
        CustomSyntaxSection.register("Define Expression", CustomExpressionSection.class, "[(2\u00a6local)] [(1\u00a6(plural|non(-|[ ])single))] expression <.+>", "[(2\u00a6local)] [(1\u00a6(plural|non(-|[ ])single))] expression", "[(2\u00a6local)] [(1\u00a6(plural|non(-|[ ])single))] %*classinfos% property <.+>");
        dataTracker = new CustomSyntaxSection.DataTracker();
        returnTypes = new HashMap();
        expressionHandlers = new HashMap<ExpressionSyntaxInfo, Trigger>();
        parserHandlers = new HashMap<ExpressionSyntaxInfo, Trigger>();
        changerHandlers = new HashMap<ExpressionSyntaxInfo, Map<Changer.ChangeMode, Trigger>>();
        changerTypes = new HashMap<ExpressionSyntaxInfo, Map<Changer.ChangeMode, Class[]>>();
        loopOfs = new HashMap<ExpressionSyntaxInfo, String>();
        dataTracker.setSyntaxType("expression");
        Skript.registerExpression(CustomExpression.class, Object.class, (ExpressionType)ExpressionType.PATTERN_MATCHES_EVERYTHING, (String[])new String[0]);
        Optional<ExpressionInfo> info = StreamSupport.stream(Spliterators.spliteratorUnknownSize(Skript.getExpressions(), 16), false).filter(i -> i.c == CustomExpression.class).findFirst();
        info.ifPresent(dataTracker::setInfo);
        dataTracker.addManaged(returnTypes);
        dataTracker.addManaged(expressionHandlers);
        dataTracker.addManaged(changerHandlers);
        dataTracker.addManaged(changerTypes);
        dataTracker.addManaged(parserHandlers);
        dataTracker.addManaged(loopOfs);
    }
}

