/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.skriptmirror.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import com.leaf.skriptmirror.skript.custom.CustomSyntaxSection;
import com.leaf.skriptmirror.util.SkriptUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.event.Event;

public class Consent
extends SelfRegisteringSkriptEvent {
    private static final Map<File, List<Feature>> consentedFeatures;
    private static final String[] CONSENT_LINES;

    public void register(Trigger t) {
    }

    public void unregister(Trigger t) {
        consentedFeatures.remove(t.getScript());
    }

    public void unregisterAll() {
        consentedFeatures.clear();
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        File currentScript = ScriptLoader.currentScript.getFile();
        SectionNode node = (SectionNode)SkriptLogger.getNode();
        if (node.getKey().toLowerCase().startsWith("on ")) {
            return false;
        }
        int consentLine = 0;
        for (Node subNode : node) {
            String text = subNode.getKey();
            if (consentLine < CONSENT_LINES.length) {
                if (!text.equals(CONSENT_LINES[consentLine])) {
                    return false;
                }
                ++consentLine;
                continue;
            }
            Feature.byCodeName(text).ifPresent(feature -> consentedFeatures.computeIfAbsent(currentScript, t -> new ArrayList()).add(feature));
        }
        SkriptUtil.clearSectionNode(node);
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "experimental consent notice";
    }

    static {
        CustomSyntaxSection.register("Consent", Consent.class, "skript-mirror, I know what I'm doing");
        consentedFeatures = new HashMap<File, List<Feature>>();
        CONSENT_LINES = new String[]{"I understand that the following features are experimental and may change in the future.", "I have read about this at https://skript-mirror.gitbook.io/docs/advanced/experiments"};
    }

    public static enum Feature {
        PROXIES("proxies"),
        DEFERRED_PARSING("deferred-parsing");

        private String codeName;

        private Feature(String codeName) {
            this.codeName = codeName;
        }

        public boolean hasConsent(File script) {
            List features = (List)consentedFeatures.get(script);
            return features != null && features.contains((Object)this);
        }

        public static Optional<Feature> byCodeName(String codeName) {
            return Arrays.stream(Feature.values()).filter(f -> codeName.equals(f.codeName)).findFirst();
        }
    }
}

