/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.nbt.nbtapi;

import com.leaf.nbt.nbtapi.NBTCompound;
import com.leaf.nbt.nbtapi.NBTContainer;
import com.leaf.nbt.nbtapi.NBTReflectionUtil;
import com.leaf.nbt.nbtapi.utils.MinecraftVersion;
import com.leaf.nbt.nbtapi.utils.annotations.AvaliableSince;
import com.leaf.nbt.nbtapi.utils.annotations.CheckUtil;
import com.leaf.nbt.nbtapi.utils.annotations.FAUtil;
import org.bukkit.block.BlockState;

public class NBTTileEntity
extends NBTCompound {
    private final BlockState tile;

    public NBTTileEntity(BlockState tile) {
        super(null, null);
        if (tile == null || !tile.isPlaced()) {
            throw new NullPointerException("Tile can't be null/not placed!");
        }
        this.tile = tile;
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getTileEntityNBTTagCompound(this.tile);
    }

    @Override
    protected void setCompound(Object compound) {
        NBTReflectionUtil.setTileEntityNBTTagCompound(this.tile, compound);
    }

    @AvaliableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        if (this.hasKey("PublicBukkitValues").booleanValue()) {
            return this.getCompound("PublicBukkitValues");
        }
        NBTContainer container = new NBTContainer();
        container.addCompound("PublicBukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(container);
        return this.getCompound("PublicBukkitValues");
    }
}

