/*
 * Decompiled with CFR 0.152.
 */
package org.codemc.worldguardwrapper.implementation.v7.event;

import com.sk89q.worldguard.bukkit.event.block.UseBlockEvent;
import com.sk89q.worldguard.bukkit.event.entity.DamageEntityEvent;
import com.sk89q.worldguard.bukkit.event.entity.UseEntityEvent;
import com.sk89q.worldguard.bukkit.protection.events.DisallowedPVPEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.codemc.worldguardwrapper.event.WrappedDamageEntityEvent;
import org.codemc.worldguardwrapper.event.WrappedDisallowedPVPEvent;
import org.codemc.worldguardwrapper.event.WrappedUseBlockEvent;
import org.codemc.worldguardwrapper.event.WrappedUseEntityEvent;

public class EventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public void onUseBlock(UseBlockEvent worldGuardEvent) {
        Player player = worldGuardEvent.getCause().getFirstPlayer();
        if (player == null) {
            return;
        }
        WrappedUseBlockEvent event = new WrappedUseBlockEvent(worldGuardEvent.getOriginalEvent(), player, worldGuardEvent.getWorld(), worldGuardEvent.getBlocks(), worldGuardEvent.getEffectiveMaterial());
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            worldGuardEvent.setResult(event.getResult());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onUseEntity(UseEntityEvent worldGuardEvent) {
        Player player = worldGuardEvent.getCause().getFirstPlayer();
        if (player == null) {
            return;
        }
        WrappedUseEntityEvent event = new WrappedUseEntityEvent(worldGuardEvent.getOriginalEvent(), player, worldGuardEvent.getTarget(), worldGuardEvent.getEntity());
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            worldGuardEvent.setResult(event.getResult());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onDamageEntity(DamageEntityEvent worldGuardEvent) {
        Player player = worldGuardEvent.getCause().getFirstPlayer();
        if (player == null) {
            return;
        }
        WrappedDamageEntityEvent event = new WrappedDamageEntityEvent(worldGuardEvent.getOriginalEvent(), player, worldGuardEvent.getTarget(), worldGuardEvent.getEntity());
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            worldGuardEvent.setResult(event.getResult());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onDisallowedPVP(DisallowedPVPEvent worldGuardEvent) {
        WrappedDisallowedPVPEvent event = new WrappedDisallowedPVPEvent(worldGuardEvent.getAttacker(), worldGuardEvent.getDefender(), worldGuardEvent.getCause());
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.getResult() != Event.Result.DEFAULT) {
            worldGuardEvent.setCancelled(event.getResult() == Event.Result.DENY);
        }
    }
}

