/*
 * Decompiled with CFR 0.152.
 */
package org.codemc.worldguardwrapper;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.codemc.worldguardwrapper.flag.IWrappedFlag;
import org.codemc.worldguardwrapper.implementation.IWorldGuardImplementation;
import org.codemc.worldguardwrapper.implementation.legacy.WorldGuardImplementation;
import org.codemc.worldguardwrapper.implementation.v6.event.EventListener;
import org.codemc.worldguardwrapper.region.IWrappedRegion;
import org.codemc.worldguardwrapper.selection.ISelection;

public class WorldGuardWrapper
implements IWorldGuardImplementation {
    private static WorldGuardWrapper instance;
    private IWorldGuardImplementation implementation;
    private Listener listener;

    public static WorldGuardWrapper getInstance() {
        if (instance == null) {
            instance = new WorldGuardWrapper();
        }
        return instance;
    }

    private WorldGuardWrapper() {
        int targetVersion;
        try {
            Class.forName("com.sk89q.worldguard.WorldGuard");
            targetVersion = 7;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.sk89q.worldguard.protection.flags.registry.FlagRegistry");
                targetVersion = 6;
            }
            catch (ClassNotFoundException e1) {
                targetVersion = -6;
            }
        }
        if (targetVersion == 6) {
            this.implementation = new org.codemc.worldguardwrapper.implementation.v6.WorldGuardImplementation();
            this.listener = new EventListener();
        } else if (targetVersion == -6) {
            this.implementation = new WorldGuardImplementation();
            this.listener = new org.codemc.worldguardwrapper.implementation.legacy.event.EventListener();
        } else {
            this.implementation = new org.codemc.worldguardwrapper.implementation.v7.WorldGuardImplementation();
            this.listener = new org.codemc.worldguardwrapper.implementation.v7.event.EventListener();
        }
    }

    public void registerEvents(JavaPlugin plugin) {
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)plugin);
    }

    @Override
    public JavaPlugin getWorldGuardPlugin() {
        return this.implementation.getWorldGuardPlugin();
    }

    @Override
    public int getApiVersion() {
        return this.implementation.getApiVersion();
    }

    @Override
    public <T> Optional<T> queryFlag(Player arg0, Location arg1, IWrappedFlag<T> arg2) {
        return this.implementation.queryFlag(arg0, arg1, arg2);
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> getFlag(String arg0, Class<T> arg1) {
        return this.implementation.getFlag(arg0, arg1);
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> registerFlag(String arg0, Class<T> arg1, T arg2) {
        return this.implementation.registerFlag(arg0, arg1, arg2);
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> registerFlag(String arg0, Class<T> arg1) {
        return this.implementation.registerFlag(arg0, arg1);
    }

    @Override
    public Optional<IWrappedRegion> getRegion(World arg0, String arg1) {
        return this.implementation.getRegion(arg0, arg1);
    }

    @Override
    public Map<String, IWrappedRegion> getRegions(World arg0) {
        return this.implementation.getRegions(arg0);
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location arg0) {
        return this.implementation.getRegions(arg0);
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location arg0, Location arg1) {
        return this.implementation.getRegions(arg0, arg1);
    }

    @Override
    public Optional<IWrappedRegion> addRegion(String arg0, List<Location> arg1, int arg2, int arg3) {
        return this.implementation.addRegion(arg0, arg1, arg2, arg3);
    }

    @Override
    public Optional<IWrappedRegion> addCuboidRegion(String arg0, Location arg1, Location arg2) {
        return this.implementation.addCuboidRegion(arg0, arg1, arg2);
    }

    @Override
    public Optional<IWrappedRegion> addRegion(String arg0, ISelection arg1) {
        return this.implementation.addRegion(arg0, arg1);
    }

    @Override
    public Optional<Set<IWrappedRegion>> removeRegion(World arg0, String arg1) {
        return this.implementation.removeRegion(arg0, arg1);
    }
}

