/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.nms.v1_11_R1;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.jitse.npclib.NPCLib;
import net.jitse.npclib.api.state.NPCSlot;
import net.jitse.npclib.hologram.Hologram;
import net.jitse.npclib.internal.MinecraftVersion;
import net.jitse.npclib.internal.NPCBase;
import net.jitse.npclib.nms.v1_11_R1.packets.PacketPlayOutEntityHeadRotationWrapper;
import net.jitse.npclib.nms.v1_11_R1.packets.PacketPlayOutEntityMetadataWrapper;
import net.jitse.npclib.nms.v1_11_R1.packets.PacketPlayOutNamedEntitySpawnWrapper;
import net.jitse.npclib.nms.v1_11_R1.packets.PacketPlayOutPlayerInfoWrapper;
import net.jitse.npclib.nms.v1_11_R1.packets.PacketPlayOutScoreboardTeamWrapper;
import net.minecraft.server.v1_11_R1.EnumItemSlot;
import net.minecraft.server.v1_11_R1.Packet;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_11_R1.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_11_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_11_R1.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_11_R1.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_11_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_11_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class NPC_v1_11_R1
extends NPCBase {
    private PacketPlayOutNamedEntitySpawn packetPlayOutNamedEntitySpawn;
    private PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeamRegister;
    private PacketPlayOutPlayerInfo packetPlayOutPlayerInfoAdd;
    private PacketPlayOutPlayerInfo packetPlayOutPlayerInfoRemove;
    private PacketPlayOutEntityHeadRotation packetPlayOutEntityHeadRotation;
    private PacketPlayOutEntityDestroy packetPlayOutEntityDestroy;
    private Set<UUID> hasTeamRegistered = new HashSet<UUID>();

    public NPC_v1_11_R1(NPCLib instance, List<String> lines) {
        super(instance, lines);
    }

    @Override
    public void createPackets() {
        this.hologram = new Hologram(MinecraftVersion.V1_11_R1, this.location.clone().add(0.0, 0.5, 0.0), this.text);
        PacketPlayOutPlayerInfoWrapper packetPlayOutPlayerInfoWrapper = new PacketPlayOutPlayerInfoWrapper();
        this.packetPlayOutScoreboardTeamRegister = new PacketPlayOutScoreboardTeamWrapper().createRegisterTeam(this.name);
        this.packetPlayOutPlayerInfoAdd = packetPlayOutPlayerInfoWrapper.create(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, this.gameProfile, this.name);
        this.packetPlayOutNamedEntitySpawn = new PacketPlayOutNamedEntitySpawnWrapper().create(this.uuid, this.location, this.entityId);
        this.packetPlayOutEntityHeadRotation = new PacketPlayOutEntityHeadRotationWrapper().create(this.location, this.entityId);
        this.packetPlayOutPlayerInfoRemove = packetPlayOutPlayerInfoWrapper.create(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, this.gameProfile, this.name);
        this.packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.entityId});
    }

    @Override
    public void onLogout(Player player) {
        super.onLogout(player);
        this.hasTeamRegistered.remove(player.getUniqueId());
    }

    @Override
    public void sendShowPackets(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        if (this.hasTeamRegistered.add(player.getUniqueId())) {
            playerConnection.sendPacket((Packet)this.packetPlayOutScoreboardTeamRegister);
        }
        playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoAdd);
        playerConnection.sendPacket((Packet)this.packetPlayOutNamedEntitySpawn);
        playerConnection.sendPacket((Packet)this.packetPlayOutEntityHeadRotation);
        this.hologram.show(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.instance.getPlugin(), () -> playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoRemove), 50L);
    }

    @Override
    public void sendHidePackets(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        playerConnection.sendPacket((Packet)this.packetPlayOutEntityDestroy);
        playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoRemove);
        this.hologram.hide(player);
    }

    @Override
    public void sendMetadataPacket(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadataWrapper().create(this.activeStates, this.entityId);
        playerConnection.sendPacket((Packet)packet);
    }

    @Override
    public void sendEquipmentPacket(Player player, NPCSlot slot, boolean auto) {
        EnumItemSlot nmsSlot;
        ItemStack item;
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        switch (slot) {
            case HELMET: {
                item = this.helmet;
                nmsSlot = EnumItemSlot.HEAD;
                break;
            }
            case CHESTPLATE: {
                item = this.chestplate;
                nmsSlot = EnumItemSlot.CHEST;
                break;
            }
            case LEGGINGS: {
                item = this.leggings;
                nmsSlot = EnumItemSlot.LEGS;
                break;
            }
            case BOOTS: {
                item = this.boots;
                nmsSlot = EnumItemSlot.FEET;
                break;
            }
            case MAINHAND: {
                item = this.inHand;
                nmsSlot = EnumItemSlot.MAINHAND;
                break;
            }
            case OFFHAND: {
                item = this.offHand;
                nmsSlot = EnumItemSlot.OFFHAND;
                break;
            }
            default: {
                if (!auto) {
                    throw new IllegalArgumentException(slot.toString() + " is not a supported slot for the version of your server");
                }
                return;
            }
        }
        PacketPlayOutEntityEquipment packet = new PacketPlayOutEntityEquipment(this.entityId, nmsSlot, CraftItemStack.asNMSCopy((ItemStack)item));
        playerConnection.sendPacket((Packet)packet);
    }
}

