/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.leaf.yaml.utils.StringUtil;
import java.io.File;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Does YAML Exist")
@Description(value={"Checks if a YAML file exists at a file location.\nYou shouldn't have to use this condition since the load yaml effect will create the file if it doesn't exist"})
@Examples(value={"yaml file \"plugins/skript-yaml/test.yml\" exists:", " ", "yaml file \"plugins/skript-yaml/test.yml\" doesn't exist:"})
@Since(value="1.3")
public class CondYamlFileExists
extends Condition {
    private Expression<String> file;
    private int mark;

    public boolean check(final Event event) {
        return this.file.check(event, (Checker)new Checker<String>(){

            public boolean check(String s) {
                String f = StringUtil.checkSeparator((String)CondYamlFileExists.this.file.getSingle(event));
                File yamlFile = null;
                if (CondYamlFileExists.this.mark == 1) {
                    yamlFile = new File(StringUtil.checkRoot(f));
                } else {
                    String server = new File("").getAbsoluteFile().getAbsolutePath();
                    yamlFile = new File(server + File.separator + f);
                }
                return yamlFile.exists();
            }
        }, this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "yaml file " + this.file.toString(e, debug) + (this.isNegated() ? " does not exist" : " exists");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.setNegated(matchedPattern == 1);
        this.mark = parse.mark;
        return true;
    }

    static {
        Skript.registerCondition(CondYamlFileExists.class, (String[])new String[]{"[(1\u00a6non[(-| )]relative)] y[a]ml file %string% exists", "[(1\u00a6non[(-| )]relative)] y[a]ml file %string% does(n't| not) exist"});
    }
}

