/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.nbt.nbtapi;

import com.leaf.nbt.nbtapi.NBTCompound;
import com.leaf.nbt.nbtapi.NBTReflectionUtil;
import com.leaf.nbt.nbtapi.utils.nmsmappings.ObjectCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class NBTFile
extends NBTCompound {
    private final File file;
    private Object nbt;

    public NBTFile(File file) throws IOException {
        super(null, null);
        this.file = file;
        if (file.exists()) {
            FileInputStream inputsteam = new FileInputStream(file);
            this.nbt = NBTReflectionUtil.readNBTFile(inputsteam);
        } else {
            this.nbt = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
            this.save();
        }
    }

    public void save() throws IOException {
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            if (!this.file.createNewFile()) {
                throw new IOException("Unable to create file at " + this.file.getAbsolutePath());
            }
        }
        FileOutputStream outStream = new FileOutputStream(this.file);
        NBTReflectionUtil.saveNBTFile(this.nbt, outStream);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Object getCompound() {
        return this.nbt;
    }

    @Override
    protected void setCompound(Object compound) {
        this.nbt = compound;
    }
}

