/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.listeners;

import java.util.Objects;
import java.util.UUID;
import net.jitse.npclib.NPCLib;
import net.jitse.npclib.internal.NPCBase;
import net.jitse.npclib.internal.NPCManager;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class ChunkListener
implements Listener {
    private final NPCLib instance;

    public ChunkListener(NPCLib instance) {
        this.instance = instance;
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        for (NPCBase npc : NPCManager.getAllNPCs()) {
            if (npc.getLocation() == null || !ChunkListener.isSameChunk(npc.getLocation(), chunk)) continue;
            for (UUID uuid : npc.getShown()) {
                if (npc.getAutoHidden().contains(uuid)) continue;
                npc.hide(Bukkit.getPlayer((UUID)uuid), true);
            }
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        for (NPCBase npc : NPCManager.getAllNPCs()) {
            if (!ChunkListener.isSameChunk(npc.getLocation(), chunk)) continue;
            for (UUID uuid : npc.getShown()) {
                Player player;
                if (!npc.getAutoHidden().contains(uuid) || (player = Bukkit.getPlayer((UUID)uuid)) == null || !Objects.equals(npc.getWorld(), player.getWorld())) continue;
                double hideDistance = this.instance.getAutoHideDistance();
                double distanceSquared = player.getLocation().distanceSquared(npc.getLocation());
                boolean inRange = distanceSquared <= hideDistance * hideDistance || distanceSquared <= (double)(Bukkit.getViewDistance() << 4);
                if (!inRange) continue;
                npc.show(player, true);
            }
        }
    }

    private static int getChunkCoordinate(int coordinate) {
        return coordinate >> 4;
    }

    private static boolean isSameChunk(Location loc, Chunk chunk) {
        return ChunkListener.getChunkCoordinate(loc.getBlockX()) == chunk.getX() && ChunkListener.getChunkCoordinate(loc.getBlockZ()) == chunk.getZ();
    }
}

