/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib;

import java.util.List;
import net.jitse.npclib.api.NPC;
import net.jitse.npclib.api.utilities.Logger;
import net.jitse.npclib.listeners.ChunkListener;
import net.jitse.npclib.listeners.PacketListener;
import net.jitse.npclib.listeners.PlayerListener;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class NPCLib {
    private final JavaPlugin plugin;
    private final Logger logger;
    private final Class<?> npcClass;
    private double autoHideDistance = 50.0;

    public NPCLib(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = new Logger("NPCLib");
        String versionName = plugin.getServer().getClass().getPackage().getName().split("\\.")[3];
        Class<?> npcClass = null;
        try {
            npcClass = Class.forName("net.jitse.npclib.nms." + versionName + ".NPC_" + versionName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.npcClass = npcClass;
        if (npcClass == null) {
            this.logger.severe("Failed to initiate. Your server's version (" + versionName + ") is not supported");
            return;
        }
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)plugin);
        pluginManager.registerEvents((Listener)new ChunkListener(this), (Plugin)plugin);
        new PacketListener().start(this);
        this.logger.info("Enabled for Minecraft " + versionName);
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public void setAutoHideDistance(double autoHideDistance) {
        this.autoHideDistance = autoHideDistance;
    }

    public double getAutoHideDistance() {
        return this.autoHideDistance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public NPC createNPC(List<String> text) {
        try {
            return (NPC)this.npcClass.getConstructors()[0].newInstance(this, text);
        }
        catch (Exception exception) {
            this.logger.warning("Failed to create NPC. Please report the following stacktrace message: " + exception.getMessage());
            return null;
        }
    }

    public NPC createNPC() {
        return this.createNPC(null);
    }
}

