/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.fastboard;

import fr.mrmicky.fastboard.FastReflection;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class FastBoard {
    private static final VersionType VERSION_TYPE;
    private static final Field PLAYER_CONNECTION;
    private static final Method SEND_PACKET;
    private static final Method PLAYER_GET_HANDLE;
    private static final Class<?> CHAT_COMPONENT_CLASS;
    private static final Method MESSAGE_FROM_STRING;
    private static final Constructor<?> PACKET_SB_OBJ;
    private static final Constructor<?> PACKET_SB_DISPLAY_OBJ;
    private static final Constructor<?> PACKET_SB_SCORE;
    private static final Constructor<?> PACKET_SB_TEAM;
    private static final Class<?> ENUM_SB_HEALTH_DISPLAY;
    private static final Class<?> ENUM_SB_ACTION;
    private static final Object ENUM_SB_HEALTH_DISPLAY_INTEGER;
    private static final Object ENUM_SB_ACTION_CHANGE;
    private static final Object ENUM_SB_ACTION_REMOVE;
    private final Player player;
    private final String id;
    private String title;
    private List<String> lines = new ArrayList<String>();
    private boolean deleted = false;

    public FastBoard(Player player) {
        this.player = player;
        this.id = "fb-" + Double.toString(Math.random()).substring(2, 10);
        try {
            this.sendObjectivePacket(ObjectiveMode.CREATE);
            this.sendDisplayObjectivePacket();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void updateTitle(String title) {
        if (title.equals(this.title)) {
            return;
        }
        if (!VersionType.V1_13.isHigherOrEqual() && title.length() > 32) {
            throw new IllegalArgumentException("Title is longer than 32 chars");
        }
        this.title = title;
        try {
            this.sendObjectivePacket(ObjectiveMode.UPDATE);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public List<String> getLines() {
        ArrayList<String> lines = new ArrayList<String>(this.lines);
        Collections.reverse(lines);
        return lines;
    }

    public void updateLines(String ... lines) {
        this.updateLines(Arrays.asList(lines));
    }

    public void updateLines(Collection<String> newLines) {
        if (!VersionType.V1_13.isHigherOrEqual()) {
            int lineCount = 0;
            for (String s : newLines) {
                if (s != null && s.length() > 30) {
                    throw new IllegalArgumentException("Line " + lineCount + " is longer than 30 chars");
                }
                ++lineCount;
            }
        }
        ArrayList<String> oldLines = new ArrayList<String>(this.lines);
        this.lines.clear();
        this.lines.addAll(newLines);
        Collections.reverse(this.lines);
        try {
            if (oldLines.size() != this.lines.size()) {
                ArrayList<String> oldLinesCopy = new ArrayList<String>(oldLines);
                if (oldLinesCopy.size() > this.lines.size()) {
                    for (int i = oldLinesCopy.size(); i > this.lines.size(); --i) {
                        this.sendTeamPacket(i - 1, TeamMode.REMOVE);
                        this.sendScorePacket(i - 1, ScoreboardAction.REMOVE);
                        oldLines.remove(oldLines.size() - 1);
                    }
                } else {
                    for (int i = oldLinesCopy.size(); i < this.lines.size(); ++i) {
                        this.sendScorePacket(i, ScoreboardAction.CHANGE);
                        this.sendTeamPacket(i, TeamMode.CREATE);
                        oldLines.add(i, this.lines.get(i));
                    }
                }
            }
            for (int i = 0; i < this.lines.size(); ++i) {
                if (Objects.equals(oldLines.get(i), this.lines.get(i))) continue;
                this.sendTeamPacket(i, TeamMode.UPDATE);
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void delete() {
        try {
            for (int i = 0; i < this.lines.size(); ++i) {
                this.sendTeamPacket(i, TeamMode.REMOVE);
            }
            this.sendObjectivePacket(ObjectiveMode.REMOVE);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        this.deleted = true;
    }

    private void sendObjectivePacket(ObjectiveMode mode) throws ReflectiveOperationException {
        Object packet = PACKET_SB_OBJ.newInstance(new Object[0]);
        this.setField(packet, String.class, this.id);
        this.setField(packet, Integer.TYPE, mode.ordinal());
        if (mode != ObjectiveMode.REMOVE) {
            this.setComponentField(packet, this.title != null ? this.title : ChatColor.RESET.toString(), 1);
            if (VersionType.V1_8.isHigherOrEqual()) {
                this.setField(packet, ENUM_SB_HEALTH_DISPLAY, ENUM_SB_HEALTH_DISPLAY_INTEGER);
            }
        } else if (VERSION_TYPE == VersionType.V1_7) {
            this.setField(packet, String.class, "", 1);
        }
        this.sendPacket(packet);
    }

    private void sendDisplayObjectivePacket() throws ReflectiveOperationException {
        Object packet = PACKET_SB_DISPLAY_OBJ.newInstance(new Object[0]);
        this.setField(packet, Integer.TYPE, 1);
        this.setField(packet, String.class, this.id);
        this.sendPacket(packet);
    }

    private void sendScorePacket(int score, ScoreboardAction action) throws ReflectiveOperationException {
        Object packet = PACKET_SB_SCORE.newInstance(new Object[0]);
        this.setField(packet, String.class, this.getColorCode(score), 0);
        if (VersionType.V1_8.isHigherOrEqual()) {
            this.setField(packet, ENUM_SB_ACTION, action == ScoreboardAction.REMOVE ? ENUM_SB_ACTION_REMOVE : ENUM_SB_ACTION_CHANGE);
        } else {
            this.setField(packet, Integer.TYPE, action.ordinal(), 1);
        }
        if (action == ScoreboardAction.CHANGE) {
            this.setField(packet, String.class, this.id, 1);
            this.setField(packet, Integer.TYPE, score);
        }
        this.sendPacket(packet);
    }

    private void sendTeamPacket(int score, TeamMode mode) throws ReflectiveOperationException {
        if (mode == TeamMode.ADD_PLAYERS || mode == TeamMode.REMOVE_PLAYERS) {
            throw new UnsupportedOperationException();
        }
        Object packet = PACKET_SB_TEAM.newInstance(new Object[0]);
        this.setField(packet, String.class, this.id + ':' + score);
        this.setField(packet, Integer.TYPE, mode.ordinal(), VERSION_TYPE == VersionType.V1_8 ? 1 : 0);
        if (mode == TeamMode.CREATE || mode == TeamMode.UPDATE) {
            String prefix;
            String line = this.lines.get(score);
            String suffix = null;
            if (line == null || line.isEmpty()) {
                prefix = this.getColorCode(score) + ChatColor.RESET;
            } else if (line.length() <= 16 || VersionType.V1_13.isHigherOrEqual()) {
                prefix = line;
            } else {
                prefix = line.substring(0, 16);
                String color = ChatColor.getLastColors((String)prefix);
                suffix = (color.isEmpty() ? ChatColor.RESET : color) + line.substring(16);
            }
            if (VERSION_TYPE != VersionType.V1_13 && (prefix.length() > 16 || suffix != null && suffix.length() > 16)) {
                throw new IllegalArgumentException("Line with score " + score + " is too long: " + line + '(' + prefix + '/' + suffix + ')');
            }
            this.setComponentField(packet, prefix, 2);
            this.setComponentField(packet, suffix == null ? "" : suffix, 3);
            this.setField(packet, String.class, "always", 4);
            this.setField(packet, String.class, "always", 5);
            if (mode == TeamMode.CREATE) {
                this.setField(packet, Collection.class, Collections.singletonList(this.getColorCode(score)));
            }
        }
        this.sendPacket(packet);
    }

    private String getColorCode(int score) {
        return ChatColor.values()[score].toString();
    }

    private void sendPacket(Object packet) throws ReflectiveOperationException {
        if (this.deleted) {
            throw new IllegalStateException("This FastBoard is deleted");
        }
        if (this.player.isOnline()) {
            Object entityPlayer = PLAYER_GET_HANDLE.invoke((Object)this.player, new Object[0]);
            Object playerConnection = PLAYER_CONNECTION.get(entityPlayer);
            SEND_PACKET.invoke(playerConnection, packet);
        }
    }

    private void setField(Object object, Class<?> fieldType, Object value) throws ReflectiveOperationException {
        this.setField(object, fieldType, value, 0);
    }

    private void setField(Object object, Class<?> fieldType, Object value, int count) throws ReflectiveOperationException {
        int i = 0;
        for (Field f : object.getClass().getDeclaredFields()) {
            if (f.getType() != fieldType || i++ != count) continue;
            f.setAccessible(true);
            f.set(object, value);
        }
    }

    private void setComponentField(Object object, String value, int count) throws ReflectiveOperationException {
        if (VERSION_TYPE != VersionType.V1_13) {
            this.setField(object, String.class, value, count);
            return;
        }
        int i = 0;
        for (Field f : object.getClass().getDeclaredFields()) {
            if (f.getType() != String.class && f.getType() != CHAT_COMPONENT_CLASS || i++ != count) continue;
            f.setAccessible(true);
            f.set(object, Array.get(MESSAGE_FROM_STRING.invoke(null, value), 0));
        }
    }

    static {
        try {
            VERSION_TYPE = FastReflection.nmsOptionalClass("ScoreboardServer$Action").isPresent() ? VersionType.V1_13 : (FastReflection.nmsOptionalClass("IScoreboardCriteria$EnumScoreboardHealthDisplay").isPresent() ? VersionType.V1_8 : VersionType.V1_7);
            Class<?> craftChatMessageClass = FastReflection.obcClass("util.CraftChatMessage");
            Class<?> entityPlayerClass = FastReflection.nmsClass("EntityPlayer");
            Class<?> playerConnectionClass = FastReflection.nmsClass("PlayerConnection");
            Class<?> craftPlayerClass = FastReflection.obcClass("entity.CraftPlayer");
            MESSAGE_FROM_STRING = craftChatMessageClass.getDeclaredMethod("fromString", String.class);
            CHAT_COMPONENT_CLASS = FastReflection.nmsClass("IChatBaseComponent");
            PLAYER_GET_HANDLE = craftPlayerClass.getDeclaredMethod("getHandle", new Class[0]);
            PLAYER_CONNECTION = entityPlayerClass.getDeclaredField("playerConnection");
            SEND_PACKET = playerConnectionClass.getDeclaredMethod("sendPacket", FastReflection.nmsClass("Packet"));
            PACKET_SB_OBJ = FastReflection.nmsClass("PacketPlayOutScoreboardObjective").getConstructor(new Class[0]);
            PACKET_SB_DISPLAY_OBJ = FastReflection.nmsClass("PacketPlayOutScoreboardDisplayObjective").getConstructor(new Class[0]);
            PACKET_SB_SCORE = FastReflection.nmsClass("PacketPlayOutScoreboardScore").getConstructor(new Class[0]);
            PACKET_SB_TEAM = FastReflection.nmsClass("PacketPlayOutScoreboardTeam").getConstructor(new Class[0]);
            if (VersionType.V1_8.isHigherOrEqual()) {
                ENUM_SB_HEALTH_DISPLAY = FastReflection.nmsClass("IScoreboardCriteria$EnumScoreboardHealthDisplay");
                ENUM_SB_ACTION = VersionType.V1_13.isHigherOrEqual() ? FastReflection.nmsClass("ScoreboardServer$Action") : FastReflection.nmsClass("PacketPlayOutScoreboardScore$EnumScoreboardAction");
                ENUM_SB_HEALTH_DISPLAY_INTEGER = FastReflection.enumValueOf(ENUM_SB_HEALTH_DISPLAY, "INTEGER");
                ENUM_SB_ACTION_CHANGE = FastReflection.enumValueOf(ENUM_SB_ACTION, "CHANGE");
                ENUM_SB_ACTION_REMOVE = FastReflection.enumValueOf(ENUM_SB_ACTION, "REMOVE");
            } else {
                ENUM_SB_HEALTH_DISPLAY = null;
                ENUM_SB_ACTION = null;
                ENUM_SB_HEALTH_DISPLAY_INTEGER = null;
                ENUM_SB_ACTION_CHANGE = null;
                ENUM_SB_ACTION_REMOVE = null;
            }
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static enum VersionType {
        V1_7,
        V1_8,
        V1_13;


        public boolean isHigherOrEqual() {
            return VERSION_TYPE.ordinal() >= this.ordinal();
        }
    }

    static enum ScoreboardAction {
        CHANGE,
        REMOVE;

    }

    static enum TeamMode {
        CREATE,
        REMOVE,
        UPDATE,
        ADD_PLAYERS,
        REMOVE_PLAYERS;

    }

    static enum ObjectiveMode {
        CREATE,
        REMOVE,
        UPDATE;

    }
}

