/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.leaf.Leaf;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Does YAML Path Have Value")
@Description(value={"Checks if one or more values exist at a path in a cached YAML file using said ID.\n  - First input is the path.\n  - Second input is the ID.\n  - If multiple paths are checked at once it will return false on the first one found to not contain a value."})
@Examples(value={"set skript-yaml value \"test.test\" from \"config\" to \"test\"", " ", "yaml path \"test.test\" in \"config\" has value:", "\tbroadcast \"value exists\""})
@Since(value="1.1.0")
public class CondNodeHasValue
extends Condition {
    private Expression<String> path;
    private Expression<String> file;

    public boolean check(final Event event) {
        return this.path.check(event, (Checker)new Checker<String>(){

            public boolean check(String s) {
                String[] paths;
                if (!Leaf.YAML_STORE.containsKey(CondNodeHasValue.this.file.getSingle(event))) {
                    return false;
                }
                if (CondNodeHasValue.this.path.isSingle()) {
                    return Leaf.YAML_STORE.get(CondNodeHasValue.this.file.getSingle(event)).getProperty((String)CondNodeHasValue.this.path.getSingle(event)) != null;
                }
                for (String p : paths = (String[])CondNodeHasValue.this.path.getAll(event)) {
                    boolean check;
                    boolean bl = check = Leaf.YAML_STORE.get(CondNodeHasValue.this.file.getSingle(event)).getProperty(p) != null;
                    if (check) continue;
                    return false;
                }
                return true;
            }
        }, this.isNegated());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "yaml path " + this.path.toString(event, debug) + " in " + this.file.toString(event, debug) + (this.isNegated() ? (this.path.isSingle() ? " does not have a value" : " do not have values") + " " : "has a value");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.path = exprs[0];
        this.file = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    static {
        Skript.registerCondition(CondNodeHasValue.class, (String[])new String[]{"[skript-]y[a]ml [(node|path)[s]] %strings% (of|in|from) %string% has [a] value[s]", "[skript-]y[a]ml [(node|path)[s]] %strings% (of|in|from) %string% does(n't| not) have [a] value[s]"});
    }
}

