/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.tinyprotocol;

import com.comphenix.tinyprotocol.Reflection;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.jitse.npclib.NPCLib;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class TinyProtocol {
    private static final AtomicInteger ID = new AtomicInteger(0);
    private static final Reflection.MethodInvoker getPlayerHandle = Reflection.getMethod("{obc}.entity.CraftPlayer", "getHandle", new Class[0]);
    private static final Reflection.FieldAccessor<Object> getConnection = Reflection.getField("{nms}.EntityPlayer", "playerConnection", Object.class);
    private static final Reflection.FieldAccessor<Object> getManager = Reflection.getField("{nms}.PlayerConnection", "networkManager", Object.class);
    private static final Reflection.FieldAccessor<Channel> getChannel = Reflection.getField("{nms}.NetworkManager", Channel.class, 0);
    private static final Class<Object> minecraftServerClass = Reflection.getUntypedClass("{nms}.MinecraftServer");
    private static final Class<Object> serverConnectionClass = Reflection.getUntypedClass("{nms}.ServerConnection");
    private static final Reflection.FieldAccessor<Object> getMinecraftServer = Reflection.getField("{obc}.CraftServer", minecraftServerClass, 0);
    private static final Reflection.FieldAccessor<Object> getServerConnection = Reflection.getField(minecraftServerClass, serverConnectionClass, 0);
    private static final Reflection.MethodInvoker getNetworkMarkers = Reflection.getTypedMethod(serverConnectionClass, null, List.class, serverConnectionClass);
    private static final Class<?> PACKET_LOGIN_IN_START = Reflection.getMinecraftClass("PacketLoginInStart");
    private static final Reflection.FieldAccessor getGameProfile = Reflection.getField(PACKET_LOGIN_IN_START, Reflection.getClass("com.mojang.authlib.GameProfile"), 0);
    private Map<String, Channel> channelLookup = new MapMaker().weakValues().makeMap();
    private Listener listener;
    private Set<Channel> uninjectedChannels = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private List<Object> networkManagers;
    private final NPCLib instance;
    private List<Channel> serverChannels = Lists.newArrayList();
    private ChannelInboundHandlerAdapter serverChannelHandler;
    private ChannelInitializer<Channel> beginInitProtocol;
    private ChannelInitializer<Channel> endInitProtocol;
    private String handlerName;
    private volatile boolean closed;
    protected Plugin plugin;

    protected TinyProtocol(final NPCLib instance) {
        this.plugin = instance.getPlugin();
        this.instance = instance;
        this.handlerName = "tiny-" + this.plugin.getName() + "-" + ID.incrementAndGet();
        this.registerBukkitEvents();
        try {
            instance.getLogger().info("Attempting to inject into netty");
            this.registerChannelHandler();
            this.registerPlayers(this.plugin);
        }
        catch (IllegalArgumentException exception) {
            instance.getLogger().warning("Attempting to delay injection");
            new BukkitRunnable(){

                public void run() {
                    TinyProtocol.this.registerChannelHandler();
                    TinyProtocol.this.registerPlayers(TinyProtocol.this.plugin);
                    instance.getLogger().info("Injection complete");
                }
            }.runTask(this.plugin);
        }
    }

    private void createServerChannelHandler() {
        this.endInitProtocol = new ChannelInitializer<Channel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void initChannel(Channel channel) throws Exception {
                try {
                    List list = TinyProtocol.this.networkManagers;
                    synchronized (list) {
                        if (!TinyProtocol.this.closed) {
                            channel.eventLoop().submit(() -> TinyProtocol.this.injectChannelInternal(channel));
                        }
                    }
                }
                catch (Exception exception) {
                    TinyProtocol.this.instance.getLogger().severe("Cannot inject incomming channel " + channel + ". Message: " + exception.getMessage());
                }
            }
        };
        this.beginInitProtocol = new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{TinyProtocol.this.endInitProtocol});
            }
        };
        this.serverChannelHandler = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                Channel channel = (Channel)msg;
                channel.pipeline().addFirst(new ChannelHandler[]{TinyProtocol.this.beginInitProtocol});
                ctx.fireChannelRead(msg);
            }
        };
    }

    private void registerBukkitEvents() {
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST)
            public final void onPlayerLogin(PlayerLoginEvent e) {
                if (TinyProtocol.this.closed) {
                    return;
                }
                Channel channel = TinyProtocol.this.getChannel(e.getPlayer());
                if (!TinyProtocol.this.uninjectedChannels.contains(channel)) {
                    TinyProtocol.this.injectPlayer(e.getPlayer());
                }
            }

            @EventHandler
            public final void onPluginDisable(PluginDisableEvent e) {
                if (e.getPlugin().equals(TinyProtocol.this.plugin)) {
                    TinyProtocol.this.close();
                }
            }
        };
        this.plugin.getServer().getPluginManager().registerEvents(this.listener, this.plugin);
    }

    private void registerChannelHandler() {
        Object mcServer = getMinecraftServer.get(Bukkit.getServer());
        Object serverConnection = getServerConnection.get(mcServer);
        boolean looking = true;
        this.networkManagers = (List)getNetworkMarkers.invoke(null, serverConnection);
        this.createServerChannelHandler();
        int i = 0;
        while (looking) {
            List list = Reflection.getField(serverConnection.getClass(), List.class, i).get(serverConnection);
            for (Object item : list) {
                if (!(item instanceof ChannelFuture)) break;
                Channel serverChannel = ((ChannelFuture)item).channel();
                this.serverChannels.add(serverChannel);
                serverChannel.pipeline().addFirst(new ChannelHandler[]{this.serverChannelHandler});
                looking = false;
            }
            ++i;
        }
    }

    private void unregisterChannelHandler() {
        if (this.serverChannelHandler == null) {
            return;
        }
        for (Channel serverChannel : this.serverChannels) {
            ChannelPipeline pipeline = serverChannel.pipeline();
            serverChannel.eventLoop().execute(() -> {
                try {
                    pipeline.remove((ChannelHandler)this.serverChannelHandler);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            });
        }
    }

    private void registerPlayers(Plugin plugin) {
        for (Player player : plugin.getServer().getOnlinePlayers()) {
            this.injectPlayer(player);
        }
    }

    public Object onPacketInAsync(Player sender, Object packet) {
        return packet;
    }

    private void injectPlayer(Player player) {
        this.injectChannelInternal((Channel)this.getChannel((Player)player)).player = player;
    }

    private PacketInterceptor injectChannelInternal(Channel channel) {
        try {
            PacketInterceptor interceptor = (PacketInterceptor)channel.pipeline().get(this.handlerName);
            if (interceptor == null) {
                interceptor = new PacketInterceptor();
                channel.pipeline().addBefore("packet_handler", this.handlerName, (ChannelHandler)interceptor);
                this.uninjectedChannels.remove(channel);
            }
            return interceptor;
        }
        catch (IllegalArgumentException exception) {
            return (PacketInterceptor)channel.pipeline().get(this.handlerName);
        }
    }

    private Channel getChannel(Player player) {
        Channel channel = this.channelLookup.get(player.getName());
        if (channel == null) {
            Object connection = getConnection.get(getPlayerHandle.invoke(player, new Object[0]));
            Object manager = getManager.get(connection);
            channel = getChannel.get(manager);
            this.channelLookup.put(player.getName(), channel);
        }
        return channel;
    }

    private void close() {
        if (!this.closed) {
            this.closed = true;
            for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                Channel channel = this.getChannel(player);
                if (!this.closed) {
                    this.uninjectedChannels.add(channel);
                }
                channel.eventLoop().execute(() -> channel.pipeline().remove(this.handlerName));
            }
            HandlerList.unregisterAll((Listener)this.listener);
            this.unregisterChannelHandler();
        }
    }

    private final class PacketInterceptor
    extends ChannelDuplexHandler {
        public volatile Player player;

        private PacketInterceptor() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Channel channel = ctx.channel();
            this.handleLoginStart(channel, msg);
            try {
                msg = TinyProtocol.this.onPacketInAsync(this.player, msg);
            }
            catch (Exception exception) {
                TinyProtocol.this.instance.getLogger().severe("Error in onPacketInAsync(). Message: " + exception.getMessage());
            }
            if (msg != null) {
                super.channelRead(ctx, msg);
            }
        }

        private void handleLoginStart(Channel channel, Object packet) {
            if (PACKET_LOGIN_IN_START.isInstance(packet)) {
                Object profile = getGameProfile.get(packet);
                TinyProtocol.this.channelLookup.put((String)Reflection.getMethod(profile.getClass(), "getName", new Class[0]).invoke(profile, new Object[0]), channel);
            }
        }
    }
}

