/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.hologram;

import com.comphenix.tinyprotocol.Reflection;
import java.util.ArrayList;
import java.util.List;
import net.jitse.npclib.internal.MinecraftVersion;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class Hologram {
    private final List<Object> armorStands = new ArrayList<Object>();
    private final List<Object> showPackets = new ArrayList<Object>();
    private final List<Object> hidePackets = new ArrayList<Object>();
    private static final double DELTA = 0.3;
    private static final Class<?> CHAT_COMPONENT_TEXT_CLAZZ = Reflection.getMinecraftClass("ChatComponentText");
    private static final Class<?> CHAT_BASE_COMPONENT_CLAZZ = Reflection.getMinecraftClass("IChatBaseComponent");
    private static final Class<?> ENTITY_ARMOR_STAND_CLAZZ = Reflection.getMinecraftClass("EntityArmorStand");
    private static final Class<?> ENTITY_LIVING_CLAZZ = Reflection.getMinecraftClass("EntityLiving");
    private static final Class<?> ENTITY_CLAZZ = Reflection.getMinecraftClass("Entity");
    private static final Class<?> CRAFT_BUKKIT_CLASS = Reflection.getCraftBukkitClass("CraftWorld");
    private static final Class<?> CRAFT_PLAYER_CLAZZ = Reflection.getCraftBukkitClass("entity.CraftPlayer");
    private static final Class<?> PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CLAZZ = Reflection.getMinecraftClass("PacketPlayOutSpawnEntityLiving");
    private static final Class<?> PACKET_PLAY_OUT_ENTITY_DESTROY_CLAZZ = Reflection.getMinecraftClass("PacketPlayOutEntityDestroy");
    private static final Class<?> PACKET_PLAY_OUT_ENTITY_METADATA_CLAZZ = Reflection.getMinecraftClass("PacketPlayOutEntityMetadata");
    private static final Class<?> DATAWATCHER_CLAZZ = Reflection.getMinecraftClass("DataWatcher");
    private static final Class<?> ENTITY_PLAYER_CLAZZ = Reflection.getMinecraftClass("EntityPlayer");
    private static final Class<?> PLAYER_CONNECTION_CLAZZ = Reflection.getMinecraftClass("PlayerConnection");
    private static final Class<?> PACKET_CLAZZ = Reflection.getMinecraftClass("Packet");
    private static final Reflection.ConstructorInvoker CHAT_COMPONENT_TEXT_CONSTRUCTOR = Reflection.getConstructor(CHAT_COMPONENT_TEXT_CLAZZ, String.class);
    private static final Reflection.ConstructorInvoker PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CONSTRUCTOR = Reflection.getConstructor(PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CLAZZ, ENTITY_LIVING_CLAZZ);
    private static final Reflection.ConstructorInvoker PACKET_PLAY_OUT_ENTITY_DESTROY_CONSTRUCTOR = Reflection.getConstructor(PACKET_PLAY_OUT_ENTITY_DESTROY_CLAZZ, int[].class);
    private static final Reflection.ConstructorInvoker PACKET_PLAY_OUT_ENTITY_METADATA_CONSTRUCTOR = Reflection.getConstructor(PACKET_PLAY_OUT_ENTITY_METADATA_CLAZZ, Integer.TYPE, DATAWATCHER_CLAZZ, Boolean.TYPE);
    private static final Reflection.FieldAccessor playerConnectionField = Reflection.getField(ENTITY_PLAYER_CLAZZ, "playerConnection", PLAYER_CONNECTION_CLAZZ);
    private static final Reflection.MethodInvoker SET_LOCATION_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
    private static final Reflection.MethodInvoker SET_SMALL_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setSmall", Boolean.TYPE);
    private static final Reflection.MethodInvoker SET_INVISIBLE_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setInvisible", Boolean.TYPE);
    private static final Reflection.MethodInvoker SET_BASE_PLATE_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setBasePlate", Boolean.TYPE);
    private static final Reflection.MethodInvoker SET_ARMS_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setArms", Boolean.TYPE);
    private static final Reflection.MethodInvoker PLAYER_GET_HANDLE_METHOD = Reflection.getMethod(CRAFT_PLAYER_CLAZZ, "getHandle", new Class[0]);
    private static final Reflection.MethodInvoker SEND_PACKET_METHOD = Reflection.getMethod(PLAYER_CONNECTION_CLAZZ, "sendPacket", PACKET_CLAZZ);
    private static final Reflection.MethodInvoker GET_ID_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "getId", new Class[0]);
    private static final Reflection.MethodInvoker GET_DATAWATCHER_METHOD = Reflection.getMethod(ENTITY_CLAZZ, "getDataWatcher", new Class[0]);
    private final MinecraftVersion version;
    private final Location start;
    private final Object worldServer;
    private List<String> text;

    public Hologram(MinecraftVersion version, Location location, List<String> text) {
        this.version = version;
        this.start = location;
        this.text = text;
        this.worldServer = Reflection.getMethod(CRAFT_BUKKIT_CLASS, "getHandle", new Class[0]).invoke(CRAFT_BUKKIT_CLASS.cast(location.getWorld()), new Object[0]);
        this.createPackets();
    }

    private void createPackets() {
        Reflection.MethodInvoker gravityMethod;
        Reflection.MethodInvoker methodInvoker = gravityMethod = this.version.isAboveOrEqual(MinecraftVersion.V1_9_R2) ? Reflection.getMethod(ENTITY_CLAZZ, "setNoGravity", Boolean.TYPE) : Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setGravity", Boolean.TYPE);
        Reflection.MethodInvoker customNameMethod = this.version.isAboveOrEqual(MinecraftVersion.V1_12_R1) ? Reflection.getMethod(ENTITY_CLAZZ, "setCustomName", this.version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_BASE_COMPONENT_CLAZZ : String.class) : Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setCustomName", String.class);
        Reflection.MethodInvoker customNameVisibilityMethod = this.version.isAboveOrEqual(MinecraftVersion.V1_12_R1) ? Reflection.getMethod(ENTITY_CLAZZ, "setCustomNameVisible", Boolean.TYPE) : Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setCustomNameVisible", Boolean.TYPE);
        Location location = this.start.clone().add(0.0, 0.3 * (double)this.text.size(), 0.0);
        Class<?> worldClass = this.worldServer.getClass().getSuperclass();
        if (this.start.getWorld().getEnvironment() != World.Environment.NORMAL) {
            worldClass = worldClass.getSuperclass();
        }
        Reflection.ConstructorInvoker entityArmorStandConstructor = this.version.isAboveOrEqual(MinecraftVersion.V1_14_R1) ? Reflection.getConstructor(ENTITY_ARMOR_STAND_CLAZZ, worldClass, Double.TYPE, Double.TYPE, Double.TYPE) : Reflection.getConstructor(ENTITY_ARMOR_STAND_CLAZZ, worldClass);
        for (String line : this.text) {
            Object entityArmorStand;
            Object object = entityArmorStand = this.version.isAboveOrEqual(MinecraftVersion.V1_14_R1) ? entityArmorStandConstructor.invoke(this.worldServer, location.getX(), location.getY(), location.getZ()) : entityArmorStandConstructor.invoke(this.worldServer);
            if (!this.version.isAboveOrEqual(MinecraftVersion.V1_14_R1)) {
                SET_LOCATION_METHOD.invoke(entityArmorStand, location.getX(), location.getY(), location.getZ(), 0, 0);
            }
            customNameMethod.invoke(entityArmorStand, this.version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_COMPONENT_TEXT_CONSTRUCTOR.invoke(line) : line);
            customNameVisibilityMethod.invoke(entityArmorStand, true);
            gravityMethod.invoke(entityArmorStand, this.version.isAboveOrEqual(MinecraftVersion.V1_9_R2));
            SET_SMALL_METHOD.invoke(entityArmorStand, true);
            SET_INVISIBLE_METHOD.invoke(entityArmorStand, true);
            SET_BASE_PLATE_METHOD.invoke(entityArmorStand, false);
            SET_ARMS_METHOD.invoke(entityArmorStand, false);
            this.armorStands.add(entityArmorStand);
            this.showPackets.add(PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CONSTRUCTOR.invoke(entityArmorStand));
            this.hidePackets.add(PACKET_PLAY_OUT_ENTITY_DESTROY_CONSTRUCTOR.invoke(new Object[]{new int[]{(Integer)GET_ID_METHOD.invoke(entityArmorStand, new Object[0])}}));
            location.subtract(0.0, 0.3, 0.0);
        }
    }

    public List<Object> getUpdatePackets(List<String> text) {
        ArrayList<Object> updatePackets = new ArrayList<Object>();
        if (this.text.size() != text.size()) {
            throw new IllegalArgumentException("When updating the text, the old and new text should have the same amount of lines");
        }
        Reflection.MethodInvoker customNameMethod = this.version.isAboveOrEqual(MinecraftVersion.V1_12_R1) ? Reflection.getMethod(ENTITY_CLAZZ, "setCustomName", this.version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_BASE_COMPONENT_CLAZZ : String.class) : Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setCustomName", String.class);
        for (int i = 0; i < text.size(); ++i) {
            Object entityArmorStand = this.armorStands.get(i);
            String oldLine = this.text.get(i);
            String newLine = text.get(i);
            customNameMethod.invoke(entityArmorStand, this.version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_COMPONENT_TEXT_CONSTRUCTOR.invoke(newLine) : newLine);
            this.showPackets.set(i, PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CONSTRUCTOR.invoke(entityArmorStand));
            if (newLine.isEmpty() && !oldLine.isEmpty()) {
                updatePackets.add(this.hidePackets.get(i));
                continue;
            }
            if (!newLine.isEmpty() && oldLine.isEmpty()) {
                updatePackets.add(this.showPackets.get(i));
                continue;
            }
            if (oldLine.equals(newLine)) continue;
            updatePackets.add(PACKET_PLAY_OUT_ENTITY_METADATA_CONSTRUCTOR.invoke(GET_ID_METHOD.invoke(entityArmorStand, new Object[0]), GET_DATAWATCHER_METHOD.invoke(entityArmorStand, new Object[0]), true));
        }
        this.text = text;
        return updatePackets;
    }

    public void update(Player player, List<Object> updatePackets) {
        Object playerConnection = playerConnectionField.get(PLAYER_GET_HANDLE_METHOD.invoke(CRAFT_PLAYER_CLAZZ.cast(player), new Object[0]));
        for (Object packet : updatePackets) {
            SEND_PACKET_METHOD.invoke(playerConnection, packet);
        }
    }

    public void show(Player player) {
        Object playerConnection = playerConnectionField.get(PLAYER_GET_HANDLE_METHOD.invoke(CRAFT_PLAYER_CLAZZ.cast(player), new Object[0]));
        for (int i = 0; i < this.text.size(); ++i) {
            if (this.text.get(i).isEmpty()) continue;
            SEND_PACKET_METHOD.invoke(playerConnection, this.showPackets.get(i));
        }
    }

    public void hide(Player player) {
        Object playerConnection = playerConnectionField.get(PLAYER_GET_HANDLE_METHOD.invoke(CRAFT_PLAYER_CLAZZ.cast(player), new Object[0]));
        for (int i = 0; i < this.text.size(); ++i) {
            if (this.text.get(i).isEmpty()) continue;
            SEND_PACKET_METHOD.invoke(playerConnection, this.hidePackets.get(i));
        }
    }
}

