/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.db;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.util.Kleenean;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;

public class ExprDataSource
extends SimpleExpression<HikariDataSource> {
    private static Map<String, HikariDataSource> connectionCache;
    private Expression<String> url;
    private Expression<Timespan> maxLifetime;

    protected HikariDataSource[] get(Event e) {
        Timespan l;
        String jdbcUrl = (String)this.url.getSingle(e);
        if (jdbcUrl == null) {
            return null;
        }
        if (!jdbcUrl.startsWith("jdbc:")) {
            jdbcUrl = "jdbc:" + jdbcUrl;
        }
        if (connectionCache.containsKey(jdbcUrl)) {
            return new HikariDataSource[]{connectionCache.get(jdbcUrl)};
        }
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(jdbcUrl);
        if (this.maxLifetime != null && (l = (Timespan)this.maxLifetime.getSingle(e)) != null) {
            ds.setMaxLifetime(l.getMilliSeconds());
        }
        connectionCache.put(jdbcUrl, ds);
        return new HikariDataSource[]{ds};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends HikariDataSource> getReturnType() {
        return HikariDataSource.class;
    }

    public String toString(Event e, boolean debug) {
        return "datasource " + this.url.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.url = exprs[0];
        this.maxLifetime = exprs[1];
        return true;
    }

    static {
        Skript.registerExpression(ExprDataSource.class, HikariDataSource.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] data(base|[ ]source) [(of|at)] %string% [with [a] [max[imum]] [connection] life[ ]time of %-timespan%]"});
        connectionCache = new HashMap<String, HikariDataSource>();
    }
}

