/*
 * Decompiled with CFR 0.152.
 */
package com.leaf;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import com.leaf.gui.GUIManager;
import com.leaf.gui.SkriptGUIEvent;
import com.leaf.util.EnumClassInfo;
import com.leaf.util.ReflectionUtils;
import com.leaf.yaml.api.ConstructedClass;
import com.leaf.yaml.api.RepresentedClass;
import com.leaf.yaml.utils.SkriptYamlUtils;
import com.leaf.yaml.utils.yaml.SkriptYamlConstructor;
import com.leaf.yaml.utils.yaml.SkriptYamlRepresenter;
import com.leaf.yaml.utils.yaml.YAMLProcessor;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.rowset.RowSetFactory;
import javax.sql.rowset.RowSetProvider;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Leaf
extends JavaPlugin {
    public static Leaf plugin;
    private static GUIManager gui;
    private static RowSetFactory rowSetFactory;
    public static final Logger LOGGER;
    public static final HashMap<String, YAMLProcessor> YAML_STORE;
    private int serverVersion;
    private static final HashMap<String, String> REGISTERED_TAGS;
    private static SkriptYamlRepresenter representer;
    private static SkriptYamlConstructor constructor;

    public static boolean isTagRegistered(String tag) {
        return REGISTERED_TAGS.containsKey(tag);
    }

    public Leaf() {
        if (plugin != null) {
            throw new IllegalStateException("LeafSK can't have two instances.");
        }
        plugin = this;
    }

    public static void registerTag(JavaPlugin plugin, String tag, Class<?> c, RepresentedClass<?> rc, ConstructedClass<?> cc) {
        String prefix = plugin.getName().toLowerCase() + "-";
        if (!tag.startsWith(prefix)) {
            tag = prefix + tag;
        }
        if (!REGISTERED_TAGS.containsKey(tag)) {
            if (!representer.contains(c)) {
                if (SkriptYamlUtils.getType(rc.getClass()) == c) {
                    if (SkriptYamlUtils.getType(((Object)cc).getClass()) == c) {
                        REGISTERED_TAGS.put(tag, plugin.getName());
                        representer.register(tag, c, rc);
                        constructor.register(tag, cc);
                    } else {
                        Leaf.warn("The class '" + c.getSimpleName() + "' that the plugin '" + plugin.getName() + "' is trying to register does not match constructed class '" + SkriptYamlUtils.getType(((Object)cc).getClass()).getSimpleName() + "' for constructor '" + ((Object)cc).getClass().getSimpleName() + "' the tag '" + tag + "' was not registered");
                    }
                } else {
                    Leaf.warn("The class '" + c.getSimpleName() + "' that the plugin '" + plugin.getName() + "' is trying to register does not match represented class '" + SkriptYamlUtils.getType(rc.getClass()).getSimpleName() + "' for representer '" + rc.getClass().getSimpleName() + "' the tag '" + tag + "' was not registered");
                }
            } else {
                Leaf.warn("The class '" + c.getSimpleName() + "' that the plugin '" + plugin.getName() + "' is trying to register for the tag '" + tag + "' is already registered");
            }
        } else {
            Leaf.warn("The plugin '" + plugin.getName() + "' is trying to register the tag '" + tag + "' but it's already registered to '" + REGISTERED_TAGS.get(tag) + "'");
        }
    }

    public void onEnable() {
        String initServerVer = Bukkit.getServer().getClass().getPackage().getName().substring(23);
        this.serverVersion = Integer.parseInt(Character.toString(initServerVer.charAt(3)));
        if (this.serverVersion == 1 && Integer.parseInt(Character.toString(initServerVer.charAt(4))) >= 0) {
            this.serverVersion = Integer.parseInt(Integer.parseInt(Character.toString(initServerVer.charAt(3))) + "" + Integer.parseInt(Character.toString(initServerVer.charAt(4))));
        }
        representer = new SkriptYamlRepresenter();
        constructor = new SkriptYamlConstructor();
        Boolean hasSkript = this.hasPlugin("Skript");
        if (!hasSkript.booleanValue() || !Skript.isAcceptRegistrations()) {
            if (!hasSkript.booleanValue()) {
                Leaf.log("Error 404 - Skript not found.", Level.SEVERE);
            } else {
                Leaf.log("LeafSK can't be loaded when the server is already loaded.", Level.SEVERE);
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        SkriptAddon leaf = Skript.registerAddon((JavaPlugin)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        try {
            EnumClassInfo.create(Sound.class, "sound").register();
            rowSetFactory = RowSetProvider.newFactory();
            leaf.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"db", "effects", "expressions", "yaml", "skript", "conditions"});
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                leaf.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"papi"});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDisable() {
        SkriptGUIEvent.getInstance().unregisterAll();
        if (gui != null) {
            gui.clearAll();
        }
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    public static Leaf getInstance() {
        return plugin;
    }

    public boolean hasPlugin(String str) {
        return plugin.getServer().getPluginManager().isPluginEnabled(str);
    }

    public void info(String msg, Object ... values) {
        Leaf.log(String.format(msg, values), Level.INFO);
    }

    public static GUIManager getGUIManager() {
        if (gui == null) {
            gui = new GUIManager(Leaf.getInstance());
        }
        return gui;
    }

    public static void log(String msg) {
        Leaf.log(msg, Level.INFO);
    }

    public static void log(String msg, Level lvl) {
        plugin.getLogger().log(lvl, msg);
    }

    public static void log(Level lvl, String ... msgs) {
        for (String msg : msgs) {
            Leaf.log(msg, lvl);
        }
    }

    public static boolean isSpigot() {
        return ReflectionUtils.hasMethod(Player.class, "spigot", new Class[0]);
    }

    public static RowSetFactory getRowSetFactory() {
        return rowSetFactory;
    }

    public static String cc(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public SkriptYamlRepresenter getRepresenter() {
        return representer;
    }

    public SkriptYamlConstructor getConstructor() {
        return constructor;
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public static void warn(String error) {
        LOGGER.warning("[LeafSK] " + error);
    }

    public static void error(String error) {
        LOGGER.severe("[LeafSK] " + error);
    }

    static {
        LOGGER = Bukkit.getServer() != null ? Bukkit.getLogger() : Logger.getLogger("global");
        YAML_STORE = new HashMap();
        REGISTERED_TAGS = new HashMap();
    }
}

