/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.internal;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.jitse.npclib.NPCLib;
import net.jitse.npclib.api.NPC;
import net.jitse.npclib.api.events.NPCHideEvent;
import net.jitse.npclib.api.events.NPCShowEvent;
import net.jitse.npclib.api.skin.Skin;
import net.jitse.npclib.api.state.NPCSlot;
import net.jitse.npclib.api.state.NPCState;
import net.jitse.npclib.hologram.Hologram;
import net.jitse.npclib.internal.NPCManager;
import net.jitse.npclib.internal.NPCPacketHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public abstract class NPCBase
implements NPC,
NPCPacketHandler {
    protected final UUID uuid = UUID.randomUUID();
    protected final int entityId = Integer.MAX_VALUE - NPCManager.getAllNPCs().size();
    protected final String name = this.uuid.toString().replace("-", "").substring(0, 10);
    protected final GameProfile gameProfile = new GameProfile(this.uuid, this.name);
    private final Set<UUID> shown = new HashSet<UUID>();
    private final Set<UUID> autoHidden = new HashSet<UUID>();
    protected double cosFOV = Math.cos(Math.toRadians(60.0));
    protected NPCState[] activeStates = new NPCState[0];
    protected NPCLib instance;
    protected List<String> text;
    protected Location location;
    protected Skin skin;
    protected Hologram hologram;
    protected ItemStack helmet;
    protected ItemStack chestplate;
    protected ItemStack leggings;
    protected ItemStack boots;
    protected ItemStack inHand;
    protected ItemStack offHand;

    public NPCBase(NPCLib instance, List<String> text) {
        this.instance = instance;
        this.text = text == null ? Collections.emptyList() : text;
        NPCManager.add(this);
    }

    public NPCLib getInstance() {
        return this.instance;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public NPC setSkin(Skin skin) {
        this.skin = skin;
        this.gameProfile.getProperties().get((Object)"textures").clear();
        if (skin != null) {
            this.gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", skin.getValue(), skin.getSignature()));
        }
        return this;
    }

    @Override
    public void destroy() {
        NPCManager.remove(this);
        for (UUID uuid : this.shown) {
            if (this.autoHidden.contains(uuid)) continue;
            this.hide(Bukkit.getPlayer((UUID)uuid), true);
        }
    }

    public void disableFOV() {
        this.cosFOV = 0.0;
    }

    public void setFOV(double fov) {
        this.cosFOV = Math.cos(Math.toRadians(fov));
    }

    public Set<UUID> getShown() {
        return this.shown;
    }

    public Set<UUID> getAutoHidden() {
        return this.autoHidden;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public World getWorld() {
        return this.location != null ? this.location.getWorld() : null;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public boolean isShown(Player player) {
        return this.shown.contains(player.getUniqueId()) && !this.autoHidden.contains(player.getUniqueId());
    }

    @Override
    public NPC setLocation(Location location) {
        this.location = location;
        return this;
    }

    @Override
    public NPC create() {
        this.createPackets();
        return this;
    }

    public void onLogout(Player player) {
        this.getAutoHidden().remove(player.getUniqueId());
        this.getShown().remove(player.getUniqueId());
    }

    @Override
    public void show(Player player) {
        this.show(player, false);
    }

    public void show(Player player, boolean auto) {
        NPCShowEvent event = new NPCShowEvent(this, player, auto);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (!this.canSeeNPC(player)) {
            if (!auto) {
                this.shown.add(player.getUniqueId());
            }
            this.autoHidden.add(player.getUniqueId());
            return;
        }
        if (auto) {
            this.sendShowPackets(player);
            this.sendMetadataPacket(player);
            this.sendEquipmentPackets(player);
        } else {
            if (this.isShown(player)) {
                throw new RuntimeException("Cannot call show method twice.");
            }
            if (this.shown.contains(player.getUniqueId())) {
                return;
            }
            this.shown.add(player.getUniqueId());
            if (player.getWorld().equals(this.location.getWorld()) && player.getLocation().distance(this.location) <= this.instance.getAutoHideDistance()) {
                this.sendShowPackets(player);
                this.sendMetadataPacket(player);
                this.sendEquipmentPackets(player);
            } else {
                this.autoHidden.add(player.getUniqueId());
            }
        }
    }

    private boolean canSeeNPC(Player player) {
        Vector dir = this.location.toVector().subtract(player.getEyeLocation().toVector()).normalize();
        return dir.dot(player.getLocation().getDirection()) >= this.cosFOV;
    }

    @Override
    public void hide(Player player) {
        this.hide(player, false);
    }

    public void hide(Player player, boolean auto) {
        NPCHideEvent event = new NPCHideEvent(this, player, auto);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (auto) {
            this.sendHidePackets(player);
        } else {
            if (!this.shown.contains(player.getUniqueId())) {
                throw new RuntimeException("Cannot call hide method without calling NPC#show.");
            }
            this.shown.remove(player.getUniqueId());
            if (player.getWorld().equals(this.location.getWorld()) && player.getLocation().distance(this.location) <= this.instance.getAutoHideDistance()) {
                this.sendHidePackets(player);
            } else {
                this.autoHidden.remove(player.getUniqueId());
            }
        }
    }

    @Override
    public NPC toggleState(NPCState state) {
        int inActiveStatesIndex = -1;
        if (this.activeStates.length == 0) {
            this.activeStates = new NPCState[]{state};
        } else {
            NPCState[] newArr;
            for (int i = 0; i < this.activeStates.length; ++i) {
                if (this.activeStates[i] != state) continue;
                inActiveStatesIndex = i;
                break;
            }
            if (inActiveStatesIndex > -1) {
                newArr = new NPCState[this.activeStates.length - 1];
                for (int i = 0; i < newArr.length; ++i) {
                    if (inActiveStatesIndex == i) continue;
                    newArr[i] = i < inActiveStatesIndex ? this.activeStates[i] : this.activeStates[i + 1];
                }
                this.activeStates = newArr;
            } else {
                newArr = new NPCState[this.activeStates.length + 1];
                System.arraycopy(this.activeStates, 0, newArr, 0, this.activeStates.length);
                newArr[this.activeStates.length] = state;
                this.activeStates = newArr;
            }
        }
        for (UUID shownUuid : this.shown) {
            Player player = Bukkit.getPlayer((UUID)shownUuid);
            if (player == null || !this.isShown(player)) continue;
            this.sendMetadataPacket(player);
        }
        return this;
    }

    @Override
    public NPC setItem(NPCSlot slot, ItemStack item) {
        if (slot == null) {
            throw new NullPointerException("Slot cannot be null");
        }
        switch (slot) {
            case HELMET: {
                this.helmet = item;
                break;
            }
            case CHESTPLATE: {
                this.chestplate = item;
                break;
            }
            case LEGGINGS: {
                this.leggings = item;
                break;
            }
            case BOOTS: {
                this.boots = item;
                break;
            }
            case MAINHAND: {
                this.inHand = item;
                break;
            }
            case OFFHAND: {
                this.offHand = item;
                break;
            }
            default: {
                throw new IllegalArgumentException("Entered an invalid inventory slot");
            }
        }
        for (UUID shownUuid : this.shown) {
            Player player = Bukkit.getPlayer((UUID)shownUuid);
            if (player == null || !this.isShown(player)) continue;
            this.sendEquipmentPacket(player, slot, false);
        }
        return this;
    }

    @Override
    public NPC setText(List<String> text) {
        List<Object> updatePackets = this.hologram.getUpdatePackets(text);
        for (UUID shownUuid : this.shown) {
            Player player = Bukkit.getPlayer((UUID)shownUuid);
            if (player == null || !this.isShown(player)) continue;
            this.hologram.update(player, updatePackets);
        }
        this.text = text;
        return this;
    }
}

