/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.leaf.Leaf;
import com.leaf.yaml.utils.yaml.YAMLProcessor;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Save YAML")
@Description(value={"Saves the current cached YAML elements to file.\n\t - Using the `[with an indentation of %-number%]` option allows you to save the file with a different amount of spacing between 1 and 10\n\t - Option to remove extra lines between nodes"})
@Examples(value={"save yaml \"config\"", "save yaml \"config\" with an indentation of 2"})
@Since(value="1.0.0")
public class EffSaveYaml
extends Effect {
    private Expression<String> file;
    private Expression<Number> yamlIndent;
    private int mark;

    protected void execute(@Nullable Event event) {
        for (String name : (String[])this.file.getAll(event)) {
            if (!Leaf.YAML_STORE.containsKey(name)) continue;
            YAMLProcessor yaml = Leaf.YAML_STORE.get(name);
            if (this.yamlIndent != null) {
                yaml.setIndent(((Number)this.yamlIndent.getSingle(event)).intValue());
            }
            yaml.save(this.mark != 1);
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "save yaml " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.yamlIndent = exprs[1];
        this.mark = parse.mark;
        return true;
    }

    static {
        Skript.registerEffect(EffSaveYaml.class, (String[])new String[]{"save [y[a]ml] %strings% [with an indentation of %-number%] [(1\u00a6[and] with(out| no) extra lines between nodes)]"});
    }
}

